<?php

/**
 * Simple Machines Forum (SMF)
 *
 * @package SMF
 * @author Simple Machines https://www.simplemachines.org
 * @copyright 2025 Simple Machines and individual contributors
 * @license https://www.simplemachines.org/about/smf/license.php BSD
 *
 * @version 2.1.6
 */

if (!defined('SMF'))
	die('No direct access...');

/**
 * Helper function for utf8_strtolower.
 *
 * Developers: Do not update the data in this function manually. Instead,
 * run "php -f other/update_unicode_data.php" on the command line.
 *
 * @return array Uppercase to lowercase maps.
 */
function utf8_strtolower_simple_maps()
{
	return array(
		"\x41" => "\x61",
		"\x42" => "\x62",
		"\x43" => "\x63",
		"\x44" => "\x64",
		"\x45" => "\x65",
		"\x46" => "\x66",
		"\x47" => "\x67",
		"\x48" => "\x68",
		"\x49" => "\x69",
		"\x4A" => "\x6A",
		"\x4B" => "\x6B",
		"\x4C" => "\x6C",
		"\x4D" => "\x6D",
		"\x4E" => "\x6E",
		"\x4F" => "\x6F",
		"\x50" => "\x70",
		"\x51" => "\x71",
		"\x52" => "\x72",
		"\x53" => "\x73",
		"\x54" => "\x74",
		"\x55" => "\x75",
		"\x56" => "\x76",
		"\x57" => "\x77",
		"\x58" => "\x78",
		"\x59" => "\x79",
		"\x5A" => "\x7A",
		"\xC3\x80" => "\xC3\xA0",
		"\xC3\x81" => "\xC3\xA1",
		"\xC3\x82" => "\xC3\xA2",
		"\xC3\x83" => "\xC3\xA3",
		"\xC3\x84" => "\xC3\xA4",
		"\xC3\x85" => "\xC3\xA5",
		"\xC3\x86" => "\xC3\xA6",
		"\xC3\x87" => "\xC3\xA7",
		"\xC3\x88" => "\xC3\xA8",
		"\xC3\x89" => "\xC3\xA9",
		"\xC3\x8A" => "\xC3\xAA",
		"\xC3\x8B" => "\xC3\xAB",
		"\xC3\x8C" => "\xC3\xAC",
		"\xC3\x8D" => "\xC3\xAD",
		"\xC3\x8E" => "\xC3\xAE",
		"\xC3\x8F" => "\xC3\xAF",
		"\xC3\x90" => "\xC3\xB0",
		"\xC3\x91" => "\xC3\xB1",
		"\xC3\x92" => "\xC3\xB2",
		"\xC3\x93" => "\xC3\xB3",
		"\xC3\x94" => "\xC3\xB4",
		"\xC3\x95" => "\xC3\xB5",
		"\xC3\x96" => "\xC3\xB6",
		"\xC3\x98" => "\xC3\xB8",
		"\xC3\x99" => "\xC3\xB9",
		"\xC3\x9A" => "\xC3\xBA",
		"\xC3\x9B" => "\xC3\xBB",
		"\xC3\x9C" => "\xC3\xBC",
		"\xC3\x9D" => "\xC3\xBD",
		"\xC3\x9E" => "\xC3\xBE",
		"\xC4\x80" => "\xC4\x81",
		"\xC4\x82" => "\xC4\x83",
		"\xC4\x84" => "\xC4\x85",
		"\xC4\x86" => "\xC4\x87",
		"\xC4\x88" => "\xC4\x89",
		"\xC4\x8A" => "\xC4\x8B",
		"\xC4\x8C" => "\xC4\x8D",
		"\xC4\x8E" => "\xC4\x8F",
		"\xC4\x90" => "\xC4\x91",
		"\xC4\x92" => "\xC4\x93",
		"\xC4\x94" => "\xC4\x95",
		"\xC4\x96" => "\xC4\x97",
		"\xC4\x98" => "\xC4\x99",
		"\xC4\x9A" => "\xC4\x9B",
		"\xC4\x9C" => "\xC4\x9D",
		"\xC4\x9E" => "\xC4\x9F",
		"\xC4\xA0" => "\xC4\xA1",
		"\xC4\xA2" => "\xC4\xA3",
		"\xC4\xA4" => "\xC4\xA5",
		"\xC4\xA6" => "\xC4\xA7",
		"\xC4\xA8" => "\xC4\xA9",
		"\xC4\xAA" => "\xC4\xAB",
		"\xC4\xAC" => "\xC4\xAD",
		"\xC4\xAE" => "\xC4\xAF",
		"\xC4\xB0" => "\x69",
		"\xC4\xB2" => "\xC4\xB3",
		"\xC4\xB4" => "\xC4\xB5",
		"\xC4\xB6" => "\xC4\xB7",
		"\xC4\xB9" => "\xC4\xBA",
		"\xC4\xBB" => "\xC4\xBC",
		"\xC4\xBD" => "\xC4\xBE",
		"\xC4\xBF" => "\xC5\x80",
		"\xC5\x81" => "\xC5\x82",
		"\xC5\x83" => "\xC5\x84",
		"\xC5\x85" => "\xC5\x86",
		"\xC5\x87" => "\xC5\x88",
		"\xC5\x8A" => "\xC5\x8B",
		"\xC5\x8C" => "\xC5\x8D",
		"\xC5\x8E" => "\xC5\x8F",
		"\xC5\x90" => "\xC5\x91",
		"\xC5\x92" => "\xC5\x93",
		"\xC5\x94" => "\xC5\x95",
		"\xC5\x96" => "\xC5\x97",
		"\xC5\x98" => "\xC5\x99",
		"\xC5\x9A" => "\xC5\x9B",
		"\xC5\x9C" => "\xC5\x9D",
		"\xC5\x9E" => "\xC5\x9F",
		"\xC5\xA0" => "\xC5\xA1",
		"\xC5\xA2" => "\xC5\xA3",
		"\xC5\xA4" => "\xC5\xA5",
		"\xC5\xA6" => "\xC5\xA7",
		"\xC5\xA8" => "\xC5\xA9",
		"\xC5\xAA" => "\xC5\xAB",
		"\xC5\xAC" => "\xC5\xAD",
		"\xC5\xAE" => "\xC5\xAF",
		"\xC5\xB0" => "\xC5\xB1",
		"\xC5\xB2" => "\xC5\xB3",
		"\xC5\xB4" => "\xC5\xB5",
		"\xC5\xB6" => "\xC5\xB7",
		"\xC5\xB8" => "\xC3\xBF",
		"\xC5\xB9" => "\xC5\xBA",
		"\xC5\xBB" => "\xC5\xBC",
		"\xC5\xBD" => "\xC5\xBE",
		"\xC6\x81" => "\xC9\x93",
		"\xC6\x82" => "\xC6\x83",
		"\xC6\x84" => "\xC6\x85",
		"\xC6\x86" => "\xC9\x94",
		"\xC6\x87" => "\xC6\x88",
		"\xC6\x89" => "\xC9\x96",
		"\xC6\x8A" => "\xC9\x97",
		"\xC6\x8B" => "\xC6\x8C",
		"\xC6\x8E" => "\xC7\x9D",
		"\xC6\x8F" => "\xC9\x99",
		"\xC6\x90" => "\xC9\x9B",
		"\xC6\x91" => "\xC6\x92",
		"\xC6\x93" => "\xC9\xA0",
		"\xC6\x94" => "\xC9\xA3",
		"\xC6\x96" => "\xC9\xA9",
		"\xC6\x97" => "\xC9\xA8",
		"\xC6\x98" => "\xC6\x99",
		"\xC6\x9C" => "\xC9\xAF",
		"\xC6\x9D" => "\xC9\xB2",
		"\xC6\x9F" => "\xC9\xB5",
		"\xC6\xA0" => "\xC6\xA1",
		"\xC6\xA2" => "\xC6\xA3",
		"\xC6\xA4" => "\xC6\xA5",
		"\xC6\xA6" => "\xCA\x80",
		"\xC6\xA7" => "\xC6\xA8",
		"\xC6\xA9" => "\xCA\x83",
		"\xC6\xAC" => "\xC6\xAD",
		"\xC6\xAE" => "\xCA\x88",
		"\xC6\xAF" => "\xC6\xB0",
		"\xC6\xB1" => "\xCA\x8A",
		"\xC6\xB2" => "\xCA\x8B",
		"\xC6\xB3" => "\xC6\xB4",
		"\xC6\xB5" => "\xC6\xB6",
		"\xC6\xB7" => "\xCA\x92",
		"\xC6\xB8" => "\xC6\xB9",
		"\xC6\xBC" => "\xC6\xBD",
		"\xC7\x84" => "\xC7\x86",
		"\xC7\x85" => "\xC7\x86",
		"\xC7\x87" => "\xC7\x89",
		"\xC7\x88" => "\xC7\x89",
		"\xC7\x8A" => "\xC7\x8C",
		"\xC7\x8B" => "\xC7\x8C",
		"\xC7\x8D" => "\xC7\x8E",
		"\xC7\x8F" => "\xC7\x90",
		"\xC7\x91" => "\xC7\x92",
		"\xC7\x93" => "\xC7\x94",
		"\xC7\x95" => "\xC7\x96",
		"\xC7\x97" => "\xC7\x98",
		"\xC7\x99" => "\xC7\x9A",
		"\xC7\x9B" => "\xC7\x9C",
		"\xC7\x9E" => "\xC7\x9F",
		"\xC7\xA0" => "\xC7\xA1",
		"\xC7\xA2" => "\xC7\xA3",
		"\xC7\xA4" => "\xC7\xA5",
		"\xC7\xA6" => "\xC7\xA7",
		"\xC7\xA8" => "\xC7\xA9",
		"\xC7\xAA" => "\xC7\xAB",
		"\xC7\xAC" => "\xC7\xAD",
		"\xC7\xAE" => "\xC7\xAF",
		"\xC7\xB1" => "\xC7\xB3",
		"\xC7\xB2" => "\xC7\xB3",
		"\xC7\xB4" => "\xC7\xB5",
		"\xC7\xB6" => "\xC6\x95",
		"\xC7\xB7" => "\xC6\xBF",
		"\xC7\xB8" => "\xC7\xB9",
		"\xC7\xBA" => "\xC7\xBB",
		"\xC7\xBC" => "\xC7\xBD",
		"\xC7\xBE" => "\xC7\xBF",
		"\xC8\x80" => "\xC8\x81",
		"\xC8\x82" => "\xC8\x83",
		"\xC8\x84" => "\xC8\x85",
		"\xC8\x86" => "\xC8\x87",
		"\xC8\x88" => "\xC8\x89",
		"\xC8\x8A" => "\xC8\x8B",
		"\xC8\x8C" => "\xC8\x8D",
		"\xC8\x8E" => "\xC8\x8F",
		"\xC8\x90" => "\xC8\x91",
		"\xC8\x92" => "\xC8\x93",
		"\xC8\x94" => "\xC8\x95",
		"\xC8\x96" => "\xC8\x97",
		"\xC8\x98" => "\xC8\x99",
		"\xC8\x9A" => "\xC8\x9B",
		"\xC8\x9C" => "\xC8\x9D",
		"\xC8\x9E" => "\xC8\x9F",
		"\xC8\xA0" => "\xC6\x9E",
		"\xC8\xA2" => "\xC8\xA3",
		"\xC8\xA4" => "\xC8\xA5",
		"\xC8\xA6" => "\xC8\xA7",
		"\xC8\xA8" => "\xC8\xA9",
		"\xC8\xAA" => "\xC8\xAB",
		"\xC8\xAC" => "\xC8\xAD",
		"\xC8\xAE" => "\xC8\xAF",
		"\xC8\xB0" => "\xC8\xB1",
		"\xC8\xB2" => "\xC8\xB3",
		"\xC8\xBA" => "\xE2\xB1\xA5",
		"\xC8\xBB" => "\xC8\xBC",
		"\xC8\xBD" => "\xC6\x9A",
		"\xC8\xBE" => "\xE2\xB1\xA6",
		"\xC9\x81" => "\xC9\x82",
		"\xC9\x83" => "\xC6\x80",
		"\xC9\x84" => "\xCA\x89",
		"\xC9\x85" => "\xCA\x8C",
		"\xC9\x86" => "\xC9\x87",
		"\xC9\x88" => "\xC9\x89",
		"\xC9\x8A" => "\xC9\x8B",
		"\xC9\x8C" => "\xC9\x8D",
		"\xC9\x8E" => "\xC9\x8F",
		"\xCD\xB0" => "\xCD\xB1",
		"\xCD\xB2" => "\xCD\xB3",
		"\xCD\xB6" => "\xCD\xB7",
		"\xCD\xBF" => "\xCF\xB3",
		"\xCE\x86" => "\xCE\xAC",
		"\xCE\x88" => "\xCE\xAD",
		"\xCE\x89" => "\xCE\xAE",
		"\xCE\x8A" => "\xCE\xAF",
		"\xCE\x8C" => "\xCF\x8C",
		"\xCE\x8E" => "\xCF\x8D",
		"\xCE\x8F" => "\xCF\x8E",
		"\xCE\x91" => "\xCE\xB1",
		"\xCE\x92" => "\xCE\xB2",
		"\xCE\x93" => "\xCE\xB3",
		"\xCE\x94" => "\xCE\xB4",
		"\xCE\x95" => "\xCE\xB5",
		"\xCE\x96" => "\xCE\xB6",
		"\xCE\x97" => "\xCE\xB7",
		"\xCE\x98" => "\xCE\xB8",
		"\xCE\x99" => "\xCE\xB9",
		"\xCE\x9A" => "\xCE\xBA",
		"\xCE\x9B" => "\xCE\xBB",
		"\xCE\x9C" => "\xCE\xBC",
		"\xCE\x9D" => "\xCE\xBD",
		"\xCE\x9E" => "\xCE\xBE",
		"\xCE\x9F" => "\xCE\xBF",
		"\xCE\xA0" => "\xCF\x80",
		"\xCE\xA1" => "\xCF\x81",
		"\xCE\xA3" => "\xCF\x83",
		"\xCE\xA4" => "\xCF\x84",
		"\xCE\xA5" => "\xCF\x85",
		"\xCE\xA6" => "\xCF\x86",
		"\xCE\xA7" => "\xCF\x87",
		"\xCE\xA8" => "\xCF\x88",
		"\xCE\xA9" => "\xCF\x89",
		"\xCE\xAA" => "\xCF\x8A",
		"\xCE\xAB" => "\xCF\x8B",
		"\xCF\x8F" => "\xCF\x97",
		"\xCF\x98" => "\xCF\x99",
		"\xCF\x9A" => "\xCF\x9B",
		"\xCF\x9C" => "\xCF\x9D",
		"\xCF\x9E" => "\xCF\x9F",
		"\xCF\xA0" => "\xCF\xA1",
		"\xCF\xA2" => "\xCF\xA3",
		"\xCF\xA4" => "\xCF\xA5",
		"\xCF\xA6" => "\xCF\xA7",
		"\xCF\xA8" => "\xCF\xA9",
		"\xCF\xAA" => "\xCF\xAB",
		"\xCF\xAC" => "\xCF\xAD",
		"\xCF\xAE" => "\xCF\xAF",
		"\xCF\xB4" => "\xCE\xB8",
		"\xCF\xB7" => "\xCF\xB8",
		"\xCF\xB9" => "\xCF\xB2",
		"\xCF\xBA" => "\xCF\xBB",
		"\xCF\xBD" => "\xCD\xBB",
		"\xCF\xBE" => "\xCD\xBC",
		"\xCF\xBF" => "\xCD\xBD",
		"\xD0\x80" => "\xD1\x90",
		"\xD0\x81" => "\xD1\x91",
		"\xD0\x82" => "\xD1\x92",
		"\xD0\x83" => "\xD1\x93",
		"\xD0\x84" => "\xD1\x94",
		"\xD0\x85" => "\xD1\x95",
		"\xD0\x86" => "\xD1\x96",
		"\xD0\x87" => "\xD1\x97",
		"\xD0\x88" => "\xD1\x98",
		"\xD0\x89" => "\xD1\x99",
		"\xD0\x8A" => "\xD1\x9A",
		"\xD0\x8B" => "\xD1\x9B",
		"\xD0\x8C" => "\xD1\x9C",
		"\xD0\x8D" => "\xD1\x9D",
		"\xD0\x8E" => "\xD1\x9E",
		"\xD0\x8F" => "\xD1\x9F",
		"\xD0\x90" => "\xD0\xB0",
		"\xD0\x91" => "\xD0\xB1",
		"\xD0\x92" => "\xD0\xB2",
		"\xD0\x93" => "\xD0\xB3",
		"\xD0\x94" => "\xD0\xB4",
		"\xD0\x95" => "\xD0\xB5",
		"\xD0\x96" => "\xD0\xB6",
		"\xD0\x97" => "\xD0\xB7",
		"\xD0\x98" => "\xD0\xB8",
		"\xD0\x99" => "\xD0\xB9",
		"\xD0\x9A" => "\xD0\xBA",
		"\xD0\x9B" => "\xD0\xBB",
		"\xD0\x9C" => "\xD0\xBC",
		"\xD0\x9D" => "\xD0\xBD",
		"\xD0\x9E" => "\xD0\xBE",
		"\xD0\x9F" => "\xD0\xBF",
		"\xD0\xA0" => "\xD1\x80",
		"\xD0\xA1" => "\xD1\x81",
		"\xD0\xA2" => "\xD1\x82",
		"\xD0\xA3" => "\xD1\x83",
		"\xD0\xA4" => "\xD1\x84",
		"\xD0\xA5" => "\xD1\x85",
		"\xD0\xA6" => "\xD1\x86",
		"\xD0\xA7" => "\xD1\x87",
		"\xD0\xA8" => "\xD1\x88",
		"\xD0\xA9" => "\xD1\x89",
		"\xD0\xAA" => "\xD1\x8A",
		"\xD0\xAB" => "\xD1\x8B",
		"\xD0\xAC" => "\xD1\x8C",
		"\xD0\xAD" => "\xD1\x8D",
		"\xD0\xAE" => "\xD1\x8E",
		"\xD0\xAF" => "\xD1\x8F",
		"\xD1\xA0" => "\xD1\xA1",
		"\xD1\xA2" => "\xD1\xA3",
		"\xD1\xA4" => "\xD1\xA5",
		"\xD1\xA6" => "\xD1\xA7",
		"\xD1\xA8" => "\xD1\xA9",
		"\xD1\xAA" => "\xD1\xAB",
		"\xD1\xAC" => "\xD1\xAD",
		"\xD1\xAE" => "\xD1\xAF",
		"\xD1\xB0" => "\xD1\xB1",
		"\xD1\xB2" => "\xD1\xB3",
		"\xD1\xB4" => "\xD1\xB5",
		"\xD1\xB6" => "\xD1\xB7",
		"\xD1\xB8" => "\xD1\xB9",
		"\xD1\xBA" => "\xD1\xBB",
		"\xD1\xBC" => "\xD1\xBD",
		"\xD1\xBE" => "\xD1\xBF",
		"\xD2\x80" => "\xD2\x81",
		"\xD2\x8A" => "\xD2\x8B",
		"\xD2\x8C" => "\xD2\x8D",
		"\xD2\x8E" => "\xD2\x8F",
		"\xD2\x90" => "\xD2\x91",
		"\xD2\x92" => "\xD2\x93",
		"\xD2\x94" => "\xD2\x95",
		"\xD2\x96" => "\xD2\x97",
		"\xD2\x98" => "\xD2\x99",
		"\xD2\x9A" => "\xD2\x9B",
		"\xD2\x9C" => "\xD2\x9D",
		"\xD2\x9E" => "\xD2\x9F",
		"\xD2\xA0" => "\xD2\xA1",
		"\xD2\xA2" => "\xD2\xA3",
		"\xD2\xA4" => "\xD2\xA5",
		"\xD2\xA6" => "\xD2\xA7",
		"\xD2\xA8" => "\xD2\xA9",
		"\xD2\xAA" => "\xD2\xAB",
		"\xD2\xAC" => "\xD2\xAD",
		"\xD2\xAE" => "\xD2\xAF",
		"\xD2\xB0" => "\xD2\xB1",
		"\xD2\xB2" => "\xD2\xB3",
		"\xD2\xB4" => "\xD2\xB5",
		"\xD2\xB6" => "\xD2\xB7",
		"\xD2\xB8" => "\xD2\xB9",
		"\xD2\xBA" => "\xD2\xBB",
		"\xD2\xBC" => "\xD2\xBD",
		"\xD2\xBE" => "\xD2\xBF",
		"\xD3\x80" => "\xD3\x8F",
		"\xD3\x81" => "\xD3\x82",
		"\xD3\x83" => "\xD3\x84",
		"\xD3\x85" => "\xD3\x86",
		"\xD3\x87" => "\xD3\x88",
		"\xD3\x89" => "\xD3\x8A",
		"\xD3\x8B" => "\xD3\x8C",
		"\xD3\x8D" => "\xD3\x8E",
		"\xD3\x90" => "\xD3\x91",
		"\xD3\x92" => "\xD3\x93",
		"\xD3\x94" => "\xD3\x95",
		"\xD3\x96" => "\xD3\x97",
		"\xD3\x98" => "\xD3\x99",
		"\xD3\x9A" => "\xD3\x9B",
		"\xD3\x9C" => "\xD3\x9D",
		"\xD3\x9E" => "\xD3\x9F",
		"\xD3\xA0" => "\xD3\xA1",
		"\xD3\xA2" => "\xD3\xA3",
		"\xD3\xA4" => "\xD3\xA5",
		"\xD3\xA6" => "\xD3\xA7",
		"\xD3\xA8" => "\xD3\xA9",
		"\xD3\xAA" => "\xD3\xAB",
		"\xD3\xAC" => "\xD3\xAD",
		"\xD3\xAE" => "\xD3\xAF",
		"\xD3\xB0" => "\xD3\xB1",
		"\xD3\xB2" => "\xD3\xB3",
		"\xD3\xB4" => "\xD3\xB5",
		"\xD3\xB6" => "\xD3\xB7",
		"\xD3\xB8" => "\xD3\xB9",
		"\xD3\xBA" => "\xD3\xBB",
		"\xD3\xBC" => "\xD3\xBD",
		"\xD3\xBE" => "\xD3\xBF",
		"\xD4\x80" => "\xD4\x81",
		"\xD4\x82" => "\xD4\x83",
		"\xD4\x84" => "\xD4\x85",
		"\xD4\x86" => "\xD4\x87",
		"\xD4\x88" => "\xD4\x89",
		"\xD4\x8A" => "\xD4\x8B",
		"\xD4\x8C" => "\xD4\x8D",
		"\xD4\x8E" => "\xD4\x8F",
		"\xD4\x90" => "\xD4\x91",
		"\xD4\x92" => "\xD4\x93",
		"\xD4\x94" => "\xD4\x95",
		"\xD4\x96" => "\xD4\x97",
		"\xD4\x98" => "\xD4\x99",
		"\xD4\x9A" => "\xD4\x9B",
		"\xD4\x9C" => "\xD4\x9D",
		"\xD4\x9E" => "\xD4\x9F",
		"\xD4\xA0" => "\xD4\xA1",
		"\xD4\xA2" => "\xD4\xA3",
		"\xD4\xA4" => "\xD4\xA5",
		"\xD4\xA6" => "\xD4\xA7",
		"\xD4\xA8" => "\xD4\xA9",
		"\xD4\xAA" => "\xD4\xAB",
		"\xD4\xAC" => "\xD4\xAD",
		"\xD4\xAE" => "\xD4\xAF",
		"\xD4\xB1" => "\xD5\xA1",
		"\xD4\xB2" => "\xD5\xA2",
		"\xD4\xB3" => "\xD5\xA3",
		"\xD4\xB4" => "\xD5\xA4",
		"\xD4\xB5" => "\xD5\xA5",
		"\xD4\xB6" => "\xD5\xA6",
		"\xD4\xB7" => "\xD5\xA7",
		"\xD4\xB8" => "\xD5\xA8",
		"\xD4\xB9" => "\xD5\xA9",
		"\xD4\xBA" => "\xD5\xAA",
		"\xD4\xBB" => "\xD5\xAB",
		"\xD4\xBC" => "\xD5\xAC",
		"\xD4\xBD" => "\xD5\xAD",
		"\xD4\xBE" => "\xD5\xAE",
		"\xD4\xBF" => "\xD5\xAF",
		"\xD5\x80" => "\xD5\xB0",
		"\xD5\x81" => "\xD5\xB1",
		"\xD5\x82" => "\xD5\xB2",
		"\xD5\x83" => "\xD5\xB3",
		"\xD5\x84" => "\xD5\xB4",
		"\xD5\x85" => "\xD5\xB5",
		"\xD5\x86" => "\xD5\xB6",
		"\xD5\x87" => "\xD5\xB7",
		"\xD5\x88" => "\xD5\xB8",
		"\xD5\x89" => "\xD5\xB9",
		"\xD5\x8A" => "\xD5\xBA",
		"\xD5\x8B" => "\xD5\xBB",
		"\xD5\x8C" => "\xD5\xBC",
		"\xD5\x8D" => "\xD5\xBD",
		"\xD5\x8E" => "\xD5\xBE",
		"\xD5\x8F" => "\xD5\xBF",
		"\xD5\x90" => "\xD6\x80",
		"\xD5\x91" => "\xD6\x81",
		"\xD5\x92" => "\xD6\x82",
		"\xD5\x93" => "\xD6\x83",
		"\xD5\x94" => "\xD6\x84",
		"\xD5\x95" => "\xD6\x85",
		"\xD5\x96" => "\xD6\x86",
		"\xE1\x82\xA0" => "\xE2\xB4\x80",
		"\xE1\x82\xA1" => "\xE2\xB4\x81",
		"\xE1\x82\xA2" => "\xE2\xB4\x82",
		"\xE1\x82\xA3" => "\xE2\xB4\x83",
		"\xE1\x82\xA4" => "\xE2\xB4\x84",
		"\xE1\x82\xA5" => "\xE2\xB4\x85",
		"\xE1\x82\xA6" => "\xE2\xB4\x86",
		"\xE1\x82\xA7" => "\xE2\xB4\x87",
		"\xE1\x82\xA8" => "\xE2\xB4\x88",
		"\xE1\x82\xA9" => "\xE2\xB4\x89",
		"\xE1\x82\xAA" => "\xE2\xB4\x8A",
		"\xE1\x82\xAB" => "\xE2\xB4\x8B",
		"\xE1\x82\xAC" => "\xE2\xB4\x8C",
		"\xE1\x82\xAD" => "\xE2\xB4\x8D",
		"\xE1\x82\xAE" => "\xE2\xB4\x8E",
		"\xE1\x82\xAF" => "\xE2\xB4\x8F",
		"\xE1\x82\xB0" => "\xE2\xB4\x90",
		"\xE1\x82\xB1" => "\xE2\xB4\x91",
		"\xE1\x82\xB2" => "\xE2\xB4\x92",
		"\xE1\x82\xB3" => "\xE2\xB4\x93",
		"\xE1\x82\xB4" => "\xE2\xB4\x94",
		"\xE1\x82\xB5" => "\xE2\xB4\x95",
		"\xE1\x82\xB6" => "\xE2\xB4\x96",
		"\xE1\x82\xB7" => "\xE2\xB4\x97",
		"\xE1\x82\xB8" => "\xE2\xB4\x98",
		"\xE1\x82\xB9" => "\xE2\xB4\x99",
		"\xE1\x82\xBA" => "\xE2\xB4\x9A",
		"\xE1\x82\xBB" => "\xE2\xB4\x9B",
		"\xE1\x82\xBC" => "\xE2\xB4\x9C",
		"\xE1\x82\xBD" => "\xE2\xB4\x9D",
		"\xE1\x82\xBE" => "\xE2\xB4\x9E",
		"\xE1\x82\xBF" => "\xE2\xB4\x9F",
		"\xE1\x83\x80" => "\xE2\xB4\xA0",
		"\xE1\x83\x81" => "\xE2\xB4\xA1",
		"\xE1\x83\x82" => "\xE2\xB4\xA2",
		"\xE1\x83\x83" => "\xE2\xB4\xA3",
		"\xE1\x83\x84" => "\xE2\xB4\xA4",
		"\xE1\x83\x85" => "\xE2\xB4\xA5",
		"\xE1\x83\x87" => "\xE2\xB4\xA7",
		"\xE1\x83\x8D" => "\xE2\xB4\xAD",
		"\xE1\x8E\xA0" => "\xEA\xAD\xB0",
		"\xE1\x8E\xA1" => "\xEA\xAD\xB1",
		"\xE1\x8E\xA2" => "\xEA\xAD\xB2",
		"\xE1\x8E\xA3" => "\xEA\xAD\xB3",
		"\xE1\x8E\xA4" => "\xEA\xAD\xB4",
		"\xE1\x8E\xA5" => "\xEA\xAD\xB5",
		"\xE1\x8E\xA6" => "\xEA\xAD\xB6",
		"\xE1\x8E\xA7" => "\xEA\xAD\xB7",
		"\xE1\x8E\xA8" => "\xEA\xAD\xB8",
		"\xE1\x8E\xA9" => "\xEA\xAD\xB9",
		"\xE1\x8E\xAA" => "\xEA\xAD\xBA",
		"\xE1\x8E\xAB" => "\xEA\xAD\xBB",
		"\xE1\x8E\xAC" => "\xEA\xAD\xBC",
		"\xE1\x8E\xAD" => "\xEA\xAD\xBD",
		"\xE1\x8E\xAE" => "\xEA\xAD\xBE",
		"\xE1\x8E\xAF" => "\xEA\xAD\xBF",
		"\xE1\x8E\xB0" => "\xEA\xAE\x80",
		"\xE1\x8E\xB1" => "\xEA\xAE\x81",
		"\xE1\x8E\xB2" => "\xEA\xAE\x82",
		"\xE1\x8E\xB3" => "\xEA\xAE\x83",
		"\xE1\x8E\xB4" => "\xEA\xAE\x84",
		"\xE1\x8E\xB5" => "\xEA\xAE\x85",
		"\xE1\x8E\xB6" => "\xEA\xAE\x86",
		"\xE1\x8E\xB7" => "\xEA\xAE\x87",
		"\xE1\x8E\xB8" => "\xEA\xAE\x88",
		"\xE1\x8E\xB9" => "\xEA\xAE\x89",
		"\xE1\x8E\xBA" => "\xEA\xAE\x8A",
		"\xE1\x8E\xBB" => "\xEA\xAE\x8B",
		"\xE1\x8E\xBC" => "\xEA\xAE\x8C",
		"\xE1\x8E\xBD" => "\xEA\xAE\x8D",
		"\xE1\x8E\xBE" => "\xEA\xAE\x8E",
		"\xE1\x8E\xBF" => "\xEA\xAE\x8F",
		"\xE1\x8F\x80" => "\xEA\xAE\x90",
		"\xE1\x8F\x81" => "\xEA\xAE\x91",
		"\xE1\x8F\x82" => "\xEA\xAE\x92",
		"\xE1\x8F\x83" => "\xEA\xAE\x93",
		"\xE1\x8F\x84" => "\xEA\xAE\x94",
		"\xE1\x8F\x85" => "\xEA\xAE\x95",
		"\xE1\x8F\x86" => "\xEA\xAE\x96",
		"\xE1\x8F\x87" => "\xEA\xAE\x97",
		"\xE1\x8F\x88" => "\xEA\xAE\x98",
		"\xE1\x8F\x89" => "\xEA\xAE\x99",
		"\xE1\x8F\x8A" => "\xEA\xAE\x9A",
		"\xE1\x8F\x8B" => "\xEA\xAE\x9B",
		"\xE1\x8F\x8C" => "\xEA\xAE\x9C",
		"\xE1\x8F\x8D" => "\xEA\xAE\x9D",
		"\xE1\x8F\x8E" => "\xEA\xAE\x9E",
		"\xE1\x8F\x8F" => "\xEA\xAE\x9F",
		"\xE1\x8F\x90" => "\xEA\xAE\xA0",
		"\xE1\x8F\x91" => "\xEA\xAE\xA1",
		"\xE1\x8F\x92" => "\xEA\xAE\xA2",
		"\xE1\x8F\x93" => "\xEA\xAE\xA3",
		"\xE1\x8F\x94" => "\xEA\xAE\xA4",
		"\xE1\x8F\x95" => "\xEA\xAE\xA5",
		"\xE1\x8F\x96" => "\xEA\xAE\xA6",
		"\xE1\x8F\x97" => "\xEA\xAE\xA7",
		"\xE1\x8F\x98" => "\xEA\xAE\xA8",
		"\xE1\x8F\x99" => "\xEA\xAE\xA9",
		"\xE1\x8F\x9A" => "\xEA\xAE\xAA",
		"\xE1\x8F\x9B" => "\xEA\xAE\xAB",
		"\xE1\x8F\x9C" => "\xEA\xAE\xAC",
		"\xE1\x8F\x9D" => "\xEA\xAE\xAD",
		"\xE1\x8F\x9E" => "\xEA\xAE\xAE",
		"\xE1\x8F\x9F" => "\xEA\xAE\xAF",
		"\xE1\x8F\xA0" => "\xEA\xAE\xB0",
		"\xE1\x8F\xA1" => "\xEA\xAE\xB1",
		"\xE1\x8F\xA2" => "\xEA\xAE\xB2",
		"\xE1\x8F\xA3" => "\xEA\xAE\xB3",
		"\xE1\x8F\xA4" => "\xEA\xAE\xB4",
		"\xE1\x8F\xA5" => "\xEA\xAE\xB5",
		"\xE1\x8F\xA6" => "\xEA\xAE\xB6",
		"\xE1\x8F\xA7" => "\xEA\xAE\xB7",
		"\xE1\x8F\xA8" => "\xEA\xAE\xB8",
		"\xE1\x8F\xA9" => "\xEA\xAE\xB9",
		"\xE1\x8F\xAA" => "\xEA\xAE\xBA",
		"\xE1\x8F\xAB" => "\xEA\xAE\xBB",
		"\xE1\x8F\xAC" => "\xEA\xAE\xBC",
		"\xE1\x8F\xAD" => "\xEA\xAE\xBD",
		"\xE1\x8F\xAE" => "\xEA\xAE\xBE",
		"\xE1\x8F\xAF" => "\xEA\xAE\xBF",
		"\xE1\x8F\xB0" => "\xE1\x8F\xB8",
		"\xE1\x8F\xB1" => "\xE1\x8F\xB9",
		"\xE1\x8F\xB2" => "\xE1\x8F\xBA",
		"\xE1\x8F\xB3" => "\xE1\x8F\xBB",
		"\xE1\x8F\xB4" => "\xE1\x8F\xBC",
		"\xE1\x8F\xB5" => "\xE1\x8F\xBD",
		"\xE1\xB2\x89" => "\xE1\xB2\x8A",
		"\xE1\xB2\x90" => "\xE1\x83\x90",
		"\xE1\xB2\x91" => "\xE1\x83\x91",
		"\xE1\xB2\x92" => "\xE1\x83\x92",
		"\xE1\xB2\x93" => "\xE1\x83\x93",
		"\xE1\xB2\x94" => "\xE1\x83\x94",
		"\xE1\xB2\x95" => "\xE1\x83\x95",
		"\xE1\xB2\x96" => "\xE1\x83\x96",
		"\xE1\xB2\x97" => "\xE1\x83\x97",
		"\xE1\xB2\x98" => "\xE1\x83\x98",
		"\xE1\xB2\x99" => "\xE1\x83\x99",
		"\xE1\xB2\x9A" => "\xE1\x83\x9A",
		"\xE1\xB2\x9B" => "\xE1\x83\x9B",
		"\xE1\xB2\x9C" => "\xE1\x83\x9C",
		"\xE1\xB2\x9D" => "\xE1\x83\x9D",
		"\xE1\xB2\x9E" => "\xE1\x83\x9E",
		"\xE1\xB2\x9F" => "\xE1\x83\x9F",
		"\xE1\xB2\xA0" => "\xE1\x83\xA0",
		"\xE1\xB2\xA1" => "\xE1\x83\xA1",
		"\xE1\xB2\xA2" => "\xE1\x83\xA2",
		"\xE1\xB2\xA3" => "\xE1\x83\xA3",
		"\xE1\xB2\xA4" => "\xE1\x83\xA4",
		"\xE1\xB2\xA5" => "\xE1\x83\xA5",
		"\xE1\xB2\xA6" => "\xE1\x83\xA6",
		"\xE1\xB2\xA7" => "\xE1\x83\xA7",
		"\xE1\xB2\xA8" => "\xE1\x83\xA8",
		"\xE1\xB2\xA9" => "\xE1\x83\xA9",
		"\xE1\xB2\xAA" => "\xE1\x83\xAA",
		"\xE1\xB2\xAB" => "\xE1\x83\xAB",
		"\xE1\xB2\xAC" => "\xE1\x83\xAC",
		"\xE1\xB2\xAD" => "\xE1\x83\xAD",
		"\xE1\xB2\xAE" => "\xE1\x83\xAE",
		"\xE1\xB2\xAF" => "\xE1\x83\xAF",
		"\xE1\xB2\xB0" => "\xE1\x83\xB0",
		"\xE1\xB2\xB1" => "\xE1\x83\xB1",
		"\xE1\xB2\xB2" => "\xE1\x83\xB2",
		"\xE1\xB2\xB3" => "\xE1\x83\xB3",
		"\xE1\xB2\xB4" => "\xE1\x83\xB4",
		"\xE1\xB2\xB5" => "\xE1\x83\xB5",
		"\xE1\xB2\xB6" => "\xE1\x83\xB6",
		"\xE1\xB2\xB7" => "\xE1\x83\xB7",
		"\xE1\xB2\xB8" => "\xE1\x83\xB8",
		"\xE1\xB2\xB9" => "\xE1\x83\xB9",
		"\xE1\xB2\xBA" => "\xE1\x83\xBA",
		"\xE1\xB2\xBD" => "\xE1\x83\xBD",
		"\xE1\xB2\xBE" => "\xE1\x83\xBE",
		"\xE1\xB2\xBF" => "\xE1\x83\xBF",
		"\xE1\xB8\x80" => "\xE1\xB8\x81",
		"\xE1\xB8\x82" => "\xE1\xB8\x83",
		"\xE1\xB8\x84" => "\xE1\xB8\x85",
		"\xE1\xB8\x86" => "\xE1\xB8\x87",
		"\xE1\xB8\x88" => "\xE1\xB8\x89",
		"\xE1\xB8\x8A" => "\xE1\xB8\x8B",
		"\xE1\xB8\x8C" => "\xE1\xB8\x8D",
		"\xE1\xB8\x8E" => "\xE1\xB8\x8F",
		"\xE1\xB8\x90" => "\xE1\xB8\x91",
		"\xE1\xB8\x92" => "\xE1\xB8\x93",
		"\xE1\xB8\x94" => "\xE1\xB8\x95",
		"\xE1\xB8\x96" => "\xE1\xB8\x97",
		"\xE1\xB8\x98" => "\xE1\xB8\x99",
		"\xE1\xB8\x9A" => "\xE1\xB8\x9B",
		"\xE1\xB8\x9C" => "\xE1\xB8\x9D",
		"\xE1\xB8\x9E" => "\xE1\xB8\x9F",
		"\xE1\xB8\xA0" => "\xE1\xB8\xA1",
		"\xE1\xB8\xA2" => "\xE1\xB8\xA3",
		"\xE1\xB8\xA4" => "\xE1\xB8\xA5",
		"\xE1\xB8\xA6" => "\xE1\xB8\xA7",
		"\xE1\xB8\xA8" => "\xE1\xB8\xA9",
		"\xE1\xB8\xAA" => "\xE1\xB8\xAB",
		"\xE1\xB8\xAC" => "\xE1\xB8\xAD",
		"\xE1\xB8\xAE" => "\xE1\xB8\xAF",
		"\xE1\xB8\xB0" => "\xE1\xB8\xB1",
		"\xE1\xB8\xB2" => "\xE1\xB8\xB3",
		"\xE1\xB8\xB4" => "\xE1\xB8\xB5",
		"\xE1\xB8\xB6" => "\xE1\xB8\xB7",
		"\xE1\xB8\xB8" => "\xE1\xB8\xB9",
		"\xE1\xB8\xBA" => "\xE1\xB8\xBB",
		"\xE1\xB8\xBC" => "\xE1\xB8\xBD",
		"\xE1\xB8\xBE" => "\xE1\xB8\xBF",
		"\xE1\xB9\x80" => "\xE1\xB9\x81",
		"\xE1\xB9\x82" => "\xE1\xB9\x83",
		"\xE1\xB9\x84" => "\xE1\xB9\x85",
		"\xE1\xB9\x86" => "\xE1\xB9\x87",
		"\xE1\xB9\x88" => "\xE1\xB9\x89",
		"\xE1\xB9\x8A" => "\xE1\xB9\x8B",
		"\xE1\xB9\x8C" => "\xE1\xB9\x8D",
		"\xE1\xB9\x8E" => "\xE1\xB9\x8F",
		"\xE1\xB9\x90" => "\xE1\xB9\x91",
		"\xE1\xB9\x92" => "\xE1\xB9\x93",
		"\xE1\xB9\x94" => "\xE1\xB9\x95",
		"\xE1\xB9\x96" => "\xE1\xB9\x97",
		"\xE1\xB9\x98" => "\xE1\xB9\x99",
		"\xE1\xB9\x9A" => "\xE1\xB9\x9B",
		"\xE1\xB9\x9C" => "\xE1\xB9\x9D",
		"\xE1\xB9\x9E" => "\xE1\xB9\x9F",
		"\xE1\xB9\xA0" => "\xE1\xB9\xA1",
		"\xE1\xB9\xA2" => "\xE1\xB9\xA3",
		"\xE1\xB9\xA4" => "\xE1\xB9\xA5",
		"\xE1\xB9\xA6" => "\xE1\xB9\xA7",
		"\xE1\xB9\xA8" => "\xE1\xB9\xA9",
		"\xE1\xB9\xAA" => "\xE1\xB9\xAB",
		"\xE1\xB9\xAC" => "\xE1\xB9\xAD",
		"\xE1\xB9\xAE" => "\xE1\xB9\xAF",
		"\xE1\xB9\xB0" => "\xE1\xB9\xB1",
		"\xE1\xB9\xB2" => "\xE1\xB9\xB3",
		"\xE1\xB9\xB4" => "\xE1\xB9\xB5",
		"\xE1\xB9\xB6" => "\xE1\xB9\xB7",
		"\xE1\xB9\xB8" => "\xE1\xB9\xB9",
		"\xE1\xB9\xBA" => "\xE1\xB9\xBB",
		"\xE1\xB9\xBC" => "\xE1\xB9\xBD",
		"\xE1\xB9\xBE" => "\xE1\xB9\xBF",
		"\xE1\xBA\x80" => "\xE1\xBA\x81",
		"\xE1\xBA\x82" => "\xE1\xBA\x83",
		"\xE1\xBA\x84" => "\xE1\xBA\x85",
		"\xE1\xBA\x86" => "\xE1\xBA\x87",
		"\xE1\xBA\x88" => "\xE1\xBA\x89",
		"\xE1\xBA\x8A" => "\xE1\xBA\x8B",
		"\xE1\xBA\x8C" => "\xE1\xBA\x8D",
		"\xE1\xBA\x8E" => "\xE1\xBA\x8F",
		"\xE1\xBA\x90" => "\xE1\xBA\x91",
		"\xE1\xBA\x92" => "\xE1\xBA\x93",
		"\xE1\xBA\x94" => "\xE1\xBA\x95",
		"\xE1\xBA\x9E" => "\xC3\x9F",
		"\xE1\xBA\xA0" => "\xE1\xBA\xA1",
		"\xE1\xBA\xA2" => "\xE1\xBA\xA3",
		"\xE1\xBA\xA4" => "\xE1\xBA\xA5",
		"\xE1\xBA\xA6" => "\xE1\xBA\xA7",
		"\xE1\xBA\xA8" => "\xE1\xBA\xA9",
		"\xE1\xBA\xAA" => "\xE1\xBA\xAB",
		"\xE1\xBA\xAC" => "\xE1\xBA\xAD",
		"\xE1\xBA\xAE" => "\xE1\xBA\xAF",
		"\xE1\xBA\xB0" => "\xE1\xBA\xB1",
		"\xE1\xBA\xB2" => "\xE1\xBA\xB3",
		"\xE1\xBA\xB4" => "\xE1\xBA\xB5",
		"\xE1\xBA\xB6" => "\xE1\xBA\xB7",
		"\xE1\xBA\xB8" => "\xE1\xBA\xB9",
		"\xE1\xBA\xBA" => "\xE1\xBA\xBB",
		"\xE1\xBA\xBC" => "\xE1\xBA\xBD",
		"\xE1\xBA\xBE" => "\xE1\xBA\xBF",
		"\xE1\xBB\x80" => "\xE1\xBB\x81",
		"\xE1\xBB\x82" => "\xE1\xBB\x83",
		"\xE1\xBB\x84" => "\xE1\xBB\x85",
		"\xE1\xBB\x86" => "\xE1\xBB\x87",
		"\xE1\xBB\x88" => "\xE1\xBB\x89",
		"\xE1\xBB\x8A" => "\xE1\xBB\x8B",
		"\xE1\xBB\x8C" => "\xE1\xBB\x8D",
		"\xE1\xBB\x8E" => "\xE1\xBB\x8F",
		"\xE1\xBB\x90" => "\xE1\xBB\x91",
		"\xE1\xBB\x92" => "\xE1\xBB\x93",
		"\xE1\xBB\x94" => "\xE1\xBB\x95",
		"\xE1\xBB\x96" => "\xE1\xBB\x97",
		"\xE1\xBB\x98" => "\xE1\xBB\x99",
		"\xE1\xBB\x9A" => "\xE1\xBB\x9B",
		"\xE1\xBB\x9C" => "\xE1\xBB\x9D",
		"\xE1\xBB\x9E" => "\xE1\xBB\x9F",
		"\xE1\xBB\xA0" => "\xE1\xBB\xA1",
		"\xE1\xBB\xA2" => "\xE1\xBB\xA3",
		"\xE1\xBB\xA4" => "\xE1\xBB\xA5",
		"\xE1\xBB\xA6" => "\xE1\xBB\xA7",
		"\xE1\xBB\xA8" => "\xE1\xBB\xA9",
		"\xE1\xBB\xAA" => "\xE1\xBB\xAB",
		"\xE1\xBB\xAC" => "\xE1\xBB\xAD",
		"\xE1\xBB\xAE" => "\xE1\xBB\xAF",
		"\xE1\xBB\xB0" => "\xE1\xBB\xB1",
		"\xE1\xBB\xB2" => "\xE1\xBB\xB3",
		"\xE1\xBB\xB4" => "\xE1\xBB\xB5",
		"\xE1\xBB\xB6" => "\xE1\xBB\xB7",
		"\xE1\xBB\xB8" => "\xE1\xBB\xB9",
		"\xE1\xBB\xBA" => "\xE1\xBB\xBB",
		"\xE1\xBB\xBC" => "\xE1\xBB\xBD",
		"\xE1\xBB\xBE" => "\xE1\xBB\xBF",
		"\xE1\xBC\x88" => "\xE1\xBC\x80",
		"\xE1\xBC\x89" => "\xE1\xBC\x81",
		"\xE1\xBC\x8A" => "\xE1\xBC\x82",
		"\xE1\xBC\x8B" => "\xE1\xBC\x83",
		"\xE1\xBC\x8C" => "\xE1\xBC\x84",
		"\xE1\xBC\x8D" => "\xE1\xBC\x85",
		"\xE1\xBC\x8E" => "\xE1\xBC\x86",
		"\xE1\xBC\x8F" => "\xE1\xBC\x87",
		"\xE1\xBC\x98" => "\xE1\xBC\x90",
		"\xE1\xBC\x99" => "\xE1\xBC\x91",
		"\xE1\xBC\x9A" => "\xE1\xBC\x92",
		"\xE1\xBC\x9B" => "\xE1\xBC\x93",
		"\xE1\xBC\x9C" => "\xE1\xBC\x94",
		"\xE1\xBC\x9D" => "\xE1\xBC\x95",
		"\xE1\xBC\xA8" => "\xE1\xBC\xA0",
		"\xE1\xBC\xA9" => "\xE1\xBC\xA1",
		"\xE1\xBC\xAA" => "\xE1\xBC\xA2",
		"\xE1\xBC\xAB" => "\xE1\xBC\xA3",
		"\xE1\xBC\xAC" => "\xE1\xBC\xA4",
		"\xE1\xBC\xAD" => "\xE1\xBC\xA5",
		"\xE1\xBC\xAE" => "\xE1\xBC\xA6",
		"\xE1\xBC\xAF" => "\xE1\xBC\xA7",
		"\xE1\xBC\xB8" => "\xE1\xBC\xB0",
		"\xE1\xBC\xB9" => "\xE1\xBC\xB1",
		"\xE1\xBC\xBA" => "\xE1\xBC\xB2",
		"\xE1\xBC\xBB" => "\xE1\xBC\xB3",
		"\xE1\xBC\xBC" => "\xE1\xBC\xB4",
		"\xE1\xBC\xBD" => "\xE1\xBC\xB5",
		"\xE1\xBC\xBE" => "\xE1\xBC\xB6",
		"\xE1\xBC\xBF" => "\xE1\xBC\xB7",
		"\xE1\xBD\x88" => "\xE1\xBD\x80",
		"\xE1\xBD\x89" => "\xE1\xBD\x81",
		"\xE1\xBD\x8A" => "\xE1\xBD\x82",
		"\xE1\xBD\x8B" => "\xE1\xBD\x83",
		"\xE1\xBD\x8C" => "\xE1\xBD\x84",
		"\xE1\xBD\x8D" => "\xE1\xBD\x85",
		"\xE1\xBD\x99" => "\xE1\xBD\x91",
		"\xE1\xBD\x9B" => "\xE1\xBD\x93",
		"\xE1\xBD\x9D" => "\xE1\xBD\x95",
		"\xE1\xBD\x9F" => "\xE1\xBD\x97",
		"\xE1\xBD\xA8" => "\xE1\xBD\xA0",
		"\xE1\xBD\xA9" => "\xE1\xBD\xA1",
		"\xE1\xBD\xAA" => "\xE1\xBD\xA2",
		"\xE1\xBD\xAB" => "\xE1\xBD\xA3",
		"\xE1\xBD\xAC" => "\xE1\xBD\xA4",
		"\xE1\xBD\xAD" => "\xE1\xBD\xA5",
		"\xE1\xBD\xAE" => "\xE1\xBD\xA6",
		"\xE1\xBD\xAF" => "\xE1\xBD\xA7",
		"\xE1\xBE\x88" => "\xE1\xBE\x80",
		"\xE1\xBE\x89" => "\xE1\xBE\x81",
		"\xE1\xBE\x8A" => "\xE1\xBE\x82",
		"\xE1\xBE\x8B" => "\xE1\xBE\x83",
		"\xE1\xBE\x8C" => "\xE1\xBE\x84",
		"\xE1\xBE\x8D" => "\xE1\xBE\x85",
		"\xE1\xBE\x8E" => "\xE1\xBE\x86",
		"\xE1\xBE\x8F" => "\xE1\xBE\x87",
		"\xE1\xBE\x98" => "\xE1\xBE\x90",
		"\xE1\xBE\x99" => "\xE1\xBE\x91",
		"\xE1\xBE\x9A" => "\xE1\xBE\x92",
		"\xE1\xBE\x9B" => "\xE1\xBE\x93",
		"\xE1\xBE\x9C" => "\xE1\xBE\x94",
		"\xE1\xBE\x9D" => "\xE1\xBE\x95",
		"\xE1\xBE\x9E" => "\xE1\xBE\x96",
		"\xE1\xBE\x9F" => "\xE1\xBE\x97",
		"\xE1\xBE\xA8" => "\xE1\xBE\xA0",
		"\xE1\xBE\xA9" => "\xE1\xBE\xA1",
		"\xE1\xBE\xAA" => "\xE1\xBE\xA2",
		"\xE1\xBE\xAB" => "\xE1\xBE\xA3",
		"\xE1\xBE\xAC" => "\xE1\xBE\xA4",
		"\xE1\xBE\xAD" => "\xE1\xBE\xA5",
		"\xE1\xBE\xAE" => "\xE1\xBE\xA6",
		"\xE1\xBE\xAF" => "\xE1\xBE\xA7",
		"\xE1\xBE\xB8" => "\xE1\xBE\xB0",
		"\xE1\xBE\xB9" => "\xE1\xBE\xB1",
		"\xE1\xBE\xBA" => "\xE1\xBD\xB0",
		"\xE1\xBE\xBB" => "\xE1\xBD\xB1",
		"\xE1\xBE\xBC" => "\xE1\xBE\xB3",
		"\xE1\xBF\x88" => "\xE1\xBD\xB2",
		"\xE1\xBF\x89" => "\xE1\xBD\xB3",
		"\xE1\xBF\x8A" => "\xE1\xBD\xB4",
		"\xE1\xBF\x8B" => "\xE1\xBD\xB5",
		"\xE1\xBF\x8C" => "\xE1\xBF\x83",
		"\xE1\xBF\x98" => "\xE1\xBF\x90",
		"\xE1\xBF\x99" => "\xE1\xBF\x91",
		"\xE1\xBF\x9A" => "\xE1\xBD\xB6",
		"\xE1\xBF\x9B" => "\xE1\xBD\xB7",
		"\xE1\xBF\xA8" => "\xE1\xBF\xA0",
		"\xE1\xBF\xA9" => "\xE1\xBF\xA1",
		"\xE1\xBF\xAA" => "\xE1\xBD\xBA",
		"\xE1\xBF\xAB" => "\xE1\xBD\xBB",
		"\xE1\xBF\xAC" => "\xE1\xBF\xA5",
		"\xE1\xBF\xB8" => "\xE1\xBD\xB8",
		"\xE1\xBF\xB9" => "\xE1\xBD\xB9",
		"\xE1\xBF\xBA" => "\xE1\xBD\xBC",
		"\xE1\xBF\xBB" => "\xE1\xBD\xBD",
		"\xE1\xBF\xBC" => "\xE1\xBF\xB3",
		"\xE2\x84\xA6" => "\xCF\x89",
		"\xE2\x84\xAA" => "\x6B",
		"\xE2\x84\xAB" => "\xC3\xA5",
		"\xE2\x84\xB2" => "\xE2\x85\x8E",
		"\xE2\x85\xA0" => "\xE2\x85\xB0",
		"\xE2\x85\xA1" => "\xE2\x85\xB1",
		"\xE2\x85\xA2" => "\xE2\x85\xB2",
		"\xE2\x85\xA3" => "\xE2\x85\xB3",
		"\xE2\x85\xA4" => "\xE2\x85\xB4",
		"\xE2\x85\xA5" => "\xE2\x85\xB5",
		"\xE2\x85\xA6" => "\xE2\x85\xB6",
		"\xE2\x85\xA7" => "\xE2\x85\xB7",
		"\xE2\x85\xA8" => "\xE2\x85\xB8",
		"\xE2\x85\xA9" => "\xE2\x85\xB9",
		"\xE2\x85\xAA" => "\xE2\x85\xBA",
		"\xE2\x85\xAB" => "\xE2\x85\xBB",
		"\xE2\x85\xAC" => "\xE2\x85\xBC",
		"\xE2\x85\xAD" => "\xE2\x85\xBD",
		"\xE2\x85\xAE" => "\xE2\x85\xBE",
		"\xE2\x85\xAF" => "\xE2\x85\xBF",
		"\xE2\x86\x83" => "\xE2\x86\x84",
		"\xE2\x92\xB6" => "\xE2\x93\x90",
		"\xE2\x92\xB7" => "\xE2\x93\x91",
		"\xE2\x92\xB8" => "\xE2\x93\x92",
		"\xE2\x92\xB9" => "\xE2\x93\x93",
		"\xE2\x92\xBA" => "\xE2\x93\x94",
		"\xE2\x92\xBB" => "\xE2\x93\x95",
		"\xE2\x92\xBC" => "\xE2\x93\x96",
		"\xE2\x92\xBD" => "\xE2\x93\x97",
		"\xE2\x92\xBE" => "\xE2\x93\x98",
		"\xE2\x92\xBF" => "\xE2\x93\x99",
		"\xE2\x93\x80" => "\xE2\x93\x9A",
		"\xE2\x93\x81" => "\xE2\x93\x9B",
		"\xE2\x93\x82" => "\xE2\x93\x9C",
		"\xE2\x93\x83" => "\xE2\x93\x9D",
		"\xE2\x93\x84" => "\xE2\x93\x9E",
		"\xE2\x93\x85" => "\xE2\x93\x9F",
		"\xE2\x93\x86" => "\xE2\x93\xA0",
		"\xE2\x93\x87" => "\xE2\x93\xA1",
		"\xE2\x93\x88" => "\xE2\x93\xA2",
		"\xE2\x93\x89" => "\xE2\x93\xA3",
		"\xE2\x93\x8A" => "\xE2\x93\xA4",
		"\xE2\x93\x8B" => "\xE2\x93\xA5",
		"\xE2\x93\x8C" => "\xE2\x93\xA6",
		"\xE2\x93\x8D" => "\xE2\x93\xA7",
		"\xE2\x93\x8E" => "\xE2\x93\xA8",
		"\xE2\x93\x8F" => "\xE2\x93\xA9",
		"\xE2\xB0\x80" => "\xE2\xB0\xB0",
		"\xE2\xB0\x81" => "\xE2\xB0\xB1",
		"\xE2\xB0\x82" => "\xE2\xB0\xB2",
		"\xE2\xB0\x83" => "\xE2\xB0\xB3",
		"\xE2\xB0\x84" => "\xE2\xB0\xB4",
		"\xE2\xB0\x85" => "\xE2\xB0\xB5",
		"\xE2\xB0\x86" => "\xE2\xB0\xB6",
		"\xE2\xB0\x87" => "\xE2\xB0\xB7",
		"\xE2\xB0\x88" => "\xE2\xB0\xB8",
		"\xE2\xB0\x89" => "\xE2\xB0\xB9",
		"\xE2\xB0\x8A" => "\xE2\xB0\xBA",
		"\xE2\xB0\x8B" => "\xE2\xB0\xBB",
		"\xE2\xB0\x8C" => "\xE2\xB0\xBC",
		"\xE2\xB0\x8D" => "\xE2\xB0\xBD",
		"\xE2\xB0\x8E" => "\xE2\xB0\xBE",
		"\xE2\xB0\x8F" => "\xE2\xB0\xBF",
		"\xE2\xB0\x90" => "\xE2\xB1\x80",
		"\xE2\xB0\x91" => "\xE2\xB1\x81",
		"\xE2\xB0\x92" => "\xE2\xB1\x82",
		"\xE2\xB0\x93" => "\xE2\xB1\x83",
		"\xE2\xB0\x94" => "\xE2\xB1\x84",
		"\xE2\xB0\x95" => "\xE2\xB1\x85",
		"\xE2\xB0\x96" => "\xE2\xB1\x86",
		"\xE2\xB0\x97" => "\xE2\xB1\x87",
		"\xE2\xB0\x98" => "\xE2\xB1\x88",
		"\xE2\xB0\x99" => "\xE2\xB1\x89",
		"\xE2\xB0\x9A" => "\xE2\xB1\x8A",
		"\xE2\xB0\x9B" => "\xE2\xB1\x8B",
		"\xE2\xB0\x9C" => "\xE2\xB1\x8C",
		"\xE2\xB0\x9D" => "\xE2\xB1\x8D",
		"\xE2\xB0\x9E" => "\xE2\xB1\x8E",
		"\xE2\xB0\x9F" => "\xE2\xB1\x8F",
		"\xE2\xB0\xA0" => "\xE2\xB1\x90",
		"\xE2\xB0\xA1" => "\xE2\xB1\x91",
		"\xE2\xB0\xA2" => "\xE2\xB1\x92",
		"\xE2\xB0\xA3" => "\xE2\xB1\x93",
		"\xE2\xB0\xA4" => "\xE2\xB1\x94",
		"\xE2\xB0\xA5" => "\xE2\xB1\x95",
		"\xE2\xB0\xA6" => "\xE2\xB1\x96",
		"\xE2\xB0\xA7" => "\xE2\xB1\x97",
		"\xE2\xB0\xA8" => "\xE2\xB1\x98",
		"\xE2\xB0\xA9" => "\xE2\xB1\x99",
		"\xE2\xB0\xAA" => "\xE2\xB1\x9A",
		"\xE2\xB0\xAB" => "\xE2\xB1\x9B",
		"\xE2\xB0\xAC" => "\xE2\xB1\x9C",
		"\xE2\xB0\xAD" => "\xE2\xB1\x9D",
		"\xE2\xB0\xAE" => "\xE2\xB1\x9E",
		"\xE2\xB0\xAF" => "\xE2\xB1\x9F",
		"\xE2\xB1\xA0" => "\xE2\xB1\xA1",
		"\xE2\xB1\xA2" => "\xC9\xAB",
		"\xE2\xB1\xA3" => "\xE1\xB5\xBD",
		"\xE2\xB1\xA4" => "\xC9\xBD",
		"\xE2\xB1\xA7" => "\xE2\xB1\xA8",
		"\xE2\xB1\xA9" => "\xE2\xB1\xAA",
		"\xE2\xB1\xAB" => "\xE2\xB1\xAC",
		"\xE2\xB1\xAD" => "\xC9\x91",
		"\xE2\xB1\xAE" => "\xC9\xB1",
		"\xE2\xB1\xAF" => "\xC9\x90",
		"\xE2\xB1\xB0" => "\xC9\x92",
		"\xE2\xB1\xB2" => "\xE2\xB1\xB3",
		"\xE2\xB1\xB5" => "\xE2\xB1\xB6",
		"\xE2\xB1\xBE" => "\xC8\xBF",
		"\xE2\xB1\xBF" => "\xC9\x80",
		"\xE2\xB2\x80" => "\xE2\xB2\x81",
		"\xE2\xB2\x82" => "\xE2\xB2\x83",
		"\xE2\xB2\x84" => "\xE2\xB2\x85",
		"\xE2\xB2\x86" => "\xE2\xB2\x87",
		"\xE2\xB2\x88" => "\xE2\xB2\x89",
		"\xE2\xB2\x8A" => "\xE2\xB2\x8B",
		"\xE2\xB2\x8C" => "\xE2\xB2\x8D",
		"\xE2\xB2\x8E" => "\xE2\xB2\x8F",
		"\xE2\xB2\x90" => "\xE2\xB2\x91",
		"\xE2\xB2\x92" => "\xE2\xB2\x93",
		"\xE2\xB2\x94" => "\xE2\xB2\x95",
		"\xE2\xB2\x96" => "\xE2\xB2\x97",
		"\xE2\xB2\x98" => "\xE2\xB2\x99",
		"\xE2\xB2\x9A" => "\xE2\xB2\x9B",
		"\xE2\xB2\x9C" => "\xE2\xB2\x9D",
		"\xE2\xB2\x9E" => "\xE2\xB2\x9F",
		"\xE2\xB2\xA0" => "\xE2\xB2\xA1",
		"\xE2\xB2\xA2" => "\xE2\xB2\xA3",
		"\xE2\xB2\xA4" => "\xE2\xB2\xA5",
		"\xE2\xB2\xA6" => "\xE2\xB2\xA7",
		"\xE2\xB2\xA8" => "\xE2\xB2\xA9",
		"\xE2\xB2\xAA" => "\xE2\xB2\xAB",
		"\xE2\xB2\xAC" => "\xE2\xB2\xAD",
		"\xE2\xB2\xAE" => "\xE2\xB2\xAF",
		"\xE2\xB2\xB0" => "\xE2\xB2\xB1",
		"\xE2\xB2\xB2" => "\xE2\xB2\xB3",
		"\xE2\xB2\xB4" => "\xE2\xB2\xB5",
		"\xE2\xB2\xB6" => "\xE2\xB2\xB7",
		"\xE2\xB2\xB8" => "\xE2\xB2\xB9",
		"\xE2\xB2\xBA" => "\xE2\xB2\xBB",
		"\xE2\xB2\xBC" => "\xE2\xB2\xBD",
		"\xE2\xB2\xBE" => "\xE2\xB2\xBF",
		"\xE2\xB3\x80" => "\xE2\xB3\x81",
		"\xE2\xB3\x82" => "\xE2\xB3\x83",
		"\xE2\xB3\x84" => "\xE2\xB3\x85",
		"\xE2\xB3\x86" => "\xE2\xB3\x87",
		"\xE2\xB3\x88" => "\xE2\xB3\x89",
		"\xE2\xB3\x8A" => "\xE2\xB3\x8B",
		"\xE2\xB3\x8C" => "\xE2\xB3\x8D",
		"\xE2\xB3\x8E" => "\xE2\xB3\x8F",
		"\xE2\xB3\x90" => "\xE2\xB3\x91",
		"\xE2\xB3\x92" => "\xE2\xB3\x93",
		"\xE2\xB3\x94" => "\xE2\xB3\x95",
		"\xE2\xB3\x96" => "\xE2\xB3\x97",
		"\xE2\xB3\x98" => "\xE2\xB3\x99",
		"\xE2\xB3\x9A" => "\xE2\xB3\x9B",
		"\xE2\xB3\x9C" => "\xE2\xB3\x9D",
		"\xE2\xB3\x9E" => "\xE2\xB3\x9F",
		"\xE2\xB3\xA0" => "\xE2\xB3\xA1",
		"\xE2\xB3\xA2" => "\xE2\xB3\xA3",
		"\xE2\xB3\xAB" => "\xE2\xB3\xAC",
		"\xE2\xB3\xAD" => "\xE2\xB3\xAE",
		"\xE2\xB3\xB2" => "\xE2\xB3\xB3",
		"\xEA\x99\x80" => "\xEA\x99\x81",
		"\xEA\x99\x82" => "\xEA\x99\x83",
		"\xEA\x99\x84" => "\xEA\x99\x85",
		"\xEA\x99\x86" => "\xEA\x99\x87",
		"\xEA\x99\x88" => "\xEA\x99\x89",
		"\xEA\x99\x8A" => "\xEA\x99\x8B",
		"\xEA\x99\x8C" => "\xEA\x99\x8D",
		"\xEA\x99\x8E" => "\xEA\x99\x8F",
		"\xEA\x99\x90" => "\xEA\x99\x91",
		"\xEA\x99\x92" => "\xEA\x99\x93",
		"\xEA\x99\x94" => "\xEA\x99\x95",
		"\xEA\x99\x96" => "\xEA\x99\x97",
		"\xEA\x99\x98" => "\xEA\x99\x99",
		"\xEA\x99\x9A" => "\xEA\x99\x9B",
		"\xEA\x99\x9C" => "\xEA\x99\x9D",
		"\xEA\x99\x9E" => "\xEA\x99\x9F",
		"\xEA\x99\xA0" => "\xEA\x99\xA1",
		"\xEA\x99\xA2" => "\xEA\x99\xA3",
		"\xEA\x99\xA4" => "\xEA\x99\xA5",
		"\xEA\x99\xA6" => "\xEA\x99\xA7",
		"\xEA\x99\xA8" => "\xEA\x99\xA9",
		"\xEA\x99\xAA" => "\xEA\x99\xAB",
		"\xEA\x99\xAC" => "\xEA\x99\xAD",
		"\xEA\x9A\x80" => "\xEA\x9A\x81",
		"\xEA\x9A\x82" => "\xEA\x9A\x83",
		"\xEA\x9A\x84" => "\xEA\x9A\x85",
		"\xEA\x9A\x86" => "\xEA\x9A\x87",
		"\xEA\x9A\x88" => "\xEA\x9A\x89",
		"\xEA\x9A\x8A" => "\xEA\x9A\x8B",
		"\xEA\x9A\x8C" => "\xEA\x9A\x8D",
		"\xEA\x9A\x8E" => "\xEA\x9A\x8F",
		"\xEA\x9A\x90" => "\xEA\x9A\x91",
		"\xEA\x9A\x92" => "\xEA\x9A\x93",
		"\xEA\x9A\x94" => "\xEA\x9A\x95",
		"\xEA\x9A\x96" => "\xEA\x9A\x97",
		"\xEA\x9A\x98" => "\xEA\x9A\x99",
		"\xEA\x9A\x9A" => "\xEA\x9A\x9B",
		"\xEA\x9C\xA2" => "\xEA\x9C\xA3",
		"\xEA\x9C\xA4" => "\xEA\x9C\xA5",
		"\xEA\x9C\xA6" => "\xEA\x9C\xA7",
		"\xEA\x9C\xA8" => "\xEA\x9C\xA9",
		"\xEA\x9C\xAA" => "\xEA\x9C\xAB",
		"\xEA\x9C\xAC" => "\xEA\x9C\xAD",
		"\xEA\x9C\xAE" => "\xEA\x9C\xAF",
		"\xEA\x9C\xB2" => "\xEA\x9C\xB3",
		"\xEA\x9C\xB4" => "\xEA\x9C\xB5",
		"\xEA\x9C\xB6" => "\xEA\x9C\xB7",
		"\xEA\x9C\xB8" => "\xEA\x9C\xB9",
		"\xEA\x9C\xBA" => "\xEA\x9C\xBB",
		"\xEA\x9C\xBC" => "\xEA\x9C\xBD",
		"\xEA\x9C\xBE" => "\xEA\x9C\xBF",
		"\xEA\x9D\x80" => "\xEA\x9D\x81",
		"\xEA\x9D\x82" => "\xEA\x9D\x83",
		"\xEA\x9D\x84" => "\xEA\x9D\x85",
		"\xEA\x9D\x86" => "\xEA\x9D\x87",
		"\xEA\x9D\x88" => "\xEA\x9D\x89",
		"\xEA\x9D\x8A" => "\xEA\x9D\x8B",
		"\xEA\x9D\x8C" => "\xEA\x9D\x8D",
		"\xEA\x9D\x8E" => "\xEA\x9D\x8F",
		"\xEA\x9D\x90" => "\xEA\x9D\x91",
		"\xEA\x9D\x92" => "\xEA\x9D\x93",
		"\xEA\x9D\x94" => "\xEA\x9D\x95",
		"\xEA\x9D\x96" => "\xEA\x9D\x97",
		"\xEA\x9D\x98" => "\xEA\x9D\x99",
		"\xEA\x9D\x9A" => "\xEA\x9D\x9B",
		"\xEA\x9D\x9C" => "\xEA\x9D\x9D",
		"\xEA\x9D\x9E" => "\xEA\x9D\x9F",
		"\xEA\x9D\xA0" => "\xEA\x9D\xA1",
		"\xEA\x9D\xA2" => "\xEA\x9D\xA3",
		"\xEA\x9D\xA4" => "\xEA\x9D\xA5",
		"\xEA\x9D\xA6" => "\xEA\x9D\xA7",
		"\xEA\x9D\xA8" => "\xEA\x9D\xA9",
		"\xEA\x9D\xAA" => "\xEA\x9D\xAB",
		"\xEA\x9D\xAC" => "\xEA\x9D\xAD",
		"\xEA\x9D\xAE" => "\xEA\x9D\xAF",
		"\xEA\x9D\xB9" => "\xEA\x9D\xBA",
		"\xEA\x9D\xBB" => "\xEA\x9D\xBC",
		"\xEA\x9D\xBD" => "\xE1\xB5\xB9",
		"\xEA\x9D\xBE" => "\xEA\x9D\xBF",
		"\xEA\x9E\x80" => "\xEA\x9E\x81",
		"\xEA\x9E\x82" => "\xEA\x9E\x83",
		"\xEA\x9E\x84" => "\xEA\x9E\x85",
		"\xEA\x9E\x86" => "\xEA\x9E\x87",
		"\xEA\x9E\x8B" => "\xEA\x9E\x8C",
		"\xEA\x9E\x8D" => "\xC9\xA5",
		"\xEA\x9E\x90" => "\xEA\x9E\x91",
		"\xEA\x9E\x92" => "\xEA\x9E\x93",
		"\xEA\x9E\x96" => "\xEA\x9E\x97",
		"\xEA\x9E\x98" => "\xEA\x9E\x99",
		"\xEA\x9E\x9A" => "\xEA\x9E\x9B",
		"\xEA\x9E\x9C" => "\xEA\x9E\x9D",
		"\xEA\x9E\x9E" => "\xEA\x9E\x9F",
		"\xEA\x9E\xA0" => "\xEA\x9E\xA1",
		"\xEA\x9E\xA2" => "\xEA\x9E\xA3",
		"\xEA\x9E\xA4" => "\xEA\x9E\xA5",
		"\xEA\x9E\xA6" => "\xEA\x9E\xA7",
		"\xEA\x9E\xA8" => "\xEA\x9E\xA9",
		"\xEA\x9E\xAA" => "\xC9\xA6",
		"\xEA\x9E\xAB" => "\xC9\x9C",
		"\xEA\x9E\xAC" => "\xC9\xA1",
		"\xEA\x9E\xAD" => "\xC9\xAC",
		"\xEA\x9E\xAE" => "\xC9\xAA",
		"\xEA\x9E\xB0" => "\xCA\x9E",
		"\xEA\x9E\xB1" => "\xCA\x87",
		"\xEA\x9E\xB2" => "\xCA\x9D",
		"\xEA\x9E\xB3" => "\xEA\xAD\x93",
		"\xEA\x9E\xB4" => "\xEA\x9E\xB5",
		"\xEA\x9E\xB6" => "\xEA\x9E\xB7",
		"\xEA\x9E\xB8" => "\xEA\x9E\xB9",
		"\xEA\x9E\xBA" => "\xEA\x9E\xBB",
		"\xEA\x9E\xBC" => "\xEA\x9E\xBD",
		"\xEA\x9E\xBE" => "\xEA\x9E\xBF",
		"\xEA\x9F\x80" => "\xEA\x9F\x81",
		"\xEA\x9F\x82" => "\xEA\x9F\x83",
		"\xEA\x9F\x84" => "\xEA\x9E\x94",
		"\xEA\x9F\x85" => "\xCA\x82",
		"\xEA\x9F\x86" => "\xE1\xB6\x8E",
		"\xEA\x9F\x87" => "\xEA\x9F\x88",
		"\xEA\x9F\x89" => "\xEA\x9F\x8A",
		"\xEA\x9F\x8B" => "\xC9\xA4",
		"\xEA\x9F\x8C" => "\xEA\x9F\x8D",
		"\xEA\x9F\x8E" => "\xEA\x9F\x8F",
		"\xEA\x9F\x90" => "\xEA\x9F\x91",
		"\xEA\x9F\x92" => "\xEA\x9F\x93",
		"\xEA\x9F\x94" => "\xEA\x9F\x95",
		"\xEA\x9F\x96" => "\xEA\x9F\x97",
		"\xEA\x9F\x98" => "\xEA\x9F\x99",
		"\xEA\x9F\x9A" => "\xEA\x9F\x9B",
		"\xEA\x9F\x9C" => "\xC6\x9B",
		"\xEA\x9F\xB5" => "\xEA\x9F\xB6",
		"\xEF\xBC\xA1" => "\xEF\xBD\x81",
		"\xEF\xBC\xA2" => "\xEF\xBD\x82",
		"\xEF\xBC\xA3" => "\xEF\xBD\x83",
		"\xEF\xBC\xA4" => "\xEF\xBD\x84",
		"\xEF\xBC\xA5" => "\xEF\xBD\x85",
		"\xEF\xBC\xA6" => "\xEF\xBD\x86",
		"\xEF\xBC\xA7" => "\xEF\xBD\x87",
		"\xEF\xBC\xA8" => "\xEF\xBD\x88",
		"\xEF\xBC\xA9" => "\xEF\xBD\x89",
		"\xEF\xBC\xAA" => "\xEF\xBD\x8A",
		"\xEF\xBC\xAB" => "\xEF\xBD\x8B",
		"\xEF\xBC\xAC" => "\xEF\xBD\x8C",
		"\xEF\xBC\xAD" => "\xEF\xBD\x8D",
		"\xEF\xBC\xAE" => "\xEF\xBD\x8E",
		"\xEF\xBC\xAF" => "\xEF\xBD\x8F",
		"\xEF\xBC\xB0" => "\xEF\xBD\x90",
		"\xEF\xBC\xB1" => "\xEF\xBD\x91",
		"\xEF\xBC\xB2" => "\xEF\xBD\x92",
		"\xEF\xBC\xB3" => "\xEF\xBD\x93",
		"\xEF\xBC\xB4" => "\xEF\xBD\x94",
		"\xEF\xBC\xB5" => "\xEF\xBD\x95",
		"\xEF\xBC\xB6" => "\xEF\xBD\x96",
		"\xEF\xBC\xB7" => "\xEF\xBD\x97",
		"\xEF\xBC\xB8" => "\xEF\xBD\x98",
		"\xEF\xBC\xB9" => "\xEF\xBD\x99",
		"\xEF\xBC\xBA" => "\xEF\xBD\x9A",
		"\xF0\x90\x90\x80" => "\xF0\x90\x90\xA8",
		"\xF0\x90\x90\x81" => "\xF0\x90\x90\xA9",
		"\xF0\x90\x90\x82" => "\xF0\x90\x90\xAA",
		"\xF0\x90\x90\x83" => "\xF0\x90\x90\xAB",
		"\xF0\x90\x90\x84" => "\xF0\x90\x90\xAC",
		"\xF0\x90\x90\x85" => "\xF0\x90\x90\xAD",
		"\xF0\x90\x90\x86" => "\xF0\x90\x90\xAE",
		"\xF0\x90\x90\x87" => "\xF0\x90\x90\xAF",
		"\xF0\x90\x90\x88" => "\xF0\x90\x90\xB0",
		"\xF0\x90\x90\x89" => "\xF0\x90\x90\xB1",
		"\xF0\x90\x90\x8A" => "\xF0\x90\x90\xB2",
		"\xF0\x90\x90\x8B" => "\xF0\x90\x90\xB3",
		"\xF0\x90\x90\x8C" => "\xF0\x90\x90\xB4",
		"\xF0\x90\x90\x8D" => "\xF0\x90\x90\xB5",
		"\xF0\x90\x90\x8E" => "\xF0\x90\x90\xB6",
		"\xF0\x90\x90\x8F" => "\xF0\x90\x90\xB7",
		"\xF0\x90\x90\x90" => "\xF0\x90\x90\xB8",
		"\xF0\x90\x90\x91" => "\xF0\x90\x90\xB9",
		"\xF0\x90\x90\x92" => "\xF0\x90\x90\xBA",
		"\xF0\x90\x90\x93" => "\xF0\x90\x90\xBB",
		"\xF0\x90\x90\x94" => "\xF0\x90\x90\xBC",
		"\xF0\x90\x90\x95" => "\xF0\x90\x90\xBD",
		"\xF0\x90\x90\x96" => "\xF0\x90\x90\xBE",
		"\xF0\x90\x90\x97" => "\xF0\x90\x90\xBF",
		"\xF0\x90\x90\x98" => "\xF0\x90\x91\x80",
		"\xF0\x90\x90\x99" => "\xF0\x90\x91\x81",
		"\xF0\x90\x90\x9A" => "\xF0\x90\x91\x82",
		"\xF0\x90\x90\x9B" => "\xF0\x90\x91\x83",
		"\xF0\x90\x90\x9C" => "\xF0\x90\x91\x84",
		"\xF0\x90\x90\x9D" => "\xF0\x90\x91\x85",
		"\xF0\x90\x90\x9E" => "\xF0\x90\x91\x86",
		"\xF0\x90\x90\x9F" => "\xF0\x90\x91\x87",
		"\xF0\x90\x90\xA0" => "\xF0\x90\x91\x88",
		"\xF0\x90\x90\xA1" => "\xF0\x90\x91\x89",
		"\xF0\x90\x90\xA2" => "\xF0\x90\x91\x8A",
		"\xF0\x90\x90\xA3" => "\xF0\x90\x91\x8B",
		"\xF0\x90\x90\xA4" => "\xF0\x90\x91\x8C",
		"\xF0\x90\x90\xA5" => "\xF0\x90\x91\x8D",
		"\xF0\x90\x90\xA6" => "\xF0\x90\x91\x8E",
		"\xF0\x90\x90\xA7" => "\xF0\x90\x91\x8F",
		"\xF0\x90\x92\xB0" => "\xF0\x90\x93\x98",
		"\xF0\x90\x92\xB1" => "\xF0\x90\x93\x99",
		"\xF0\x90\x92\xB2" => "\xF0\x90\x93\x9A",
		"\xF0\x90\x92\xB3" => "\xF0\x90\x93\x9B",
		"\xF0\x90\x92\xB4" => "\xF0\x90\x93\x9C",
		"\xF0\x90\x92\xB5" => "\xF0\x90\x93\x9D",
		"\xF0\x90\x92\xB6" => "\xF0\x90\x93\x9E",
		"\xF0\x90\x92\xB7" => "\xF0\x90\x93\x9F",
		"\xF0\x90\x92\xB8" => "\xF0\x90\x93\xA0",
		"\xF0\x90\x92\xB9" => "\xF0\x90\x93\xA1",
		"\xF0\x90\x92\xBA" => "\xF0\x90\x93\xA2",
		"\xF0\x90\x92\xBB" => "\xF0\x90\x93\xA3",
		"\xF0\x90\x92\xBC" => "\xF0\x90\x93\xA4",
		"\xF0\x90\x92\xBD" => "\xF0\x90\x93\xA5",
		"\xF0\x90\x92\xBE" => "\xF0\x90\x93\xA6",
		"\xF0\x90\x92\xBF" => "\xF0\x90\x93\xA7",
		"\xF0\x90\x93\x80" => "\xF0\x90\x93\xA8",
		"\xF0\x90\x93\x81" => "\xF0\x90\x93\xA9",
		"\xF0\x90\x93\x82" => "\xF0\x90\x93\xAA",
		"\xF0\x90\x93\x83" => "\xF0\x90\x93\xAB",
		"\xF0\x90\x93\x84" => "\xF0\x90\x93\xAC",
		"\xF0\x90\x93\x85" => "\xF0\x90\x93\xAD",
		"\xF0\x90\x93\x86" => "\xF0\x90\x93\xAE",
		"\xF0\x90\x93\x87" => "\xF0\x90\x93\xAF",
		"\xF0\x90\x93\x88" => "\xF0\x90\x93\xB0",
		"\xF0\x90\x93\x89" => "\xF0\x90\x93\xB1",
		"\xF0\x90\x93\x8A" => "\xF0\x90\x93\xB2",
		"\xF0\x90\x93\x8B" => "\xF0\x90\x93\xB3",
		"\xF0\x90\x93\x8C" => "\xF0\x90\x93\xB4",
		"\xF0\x90\x93\x8D" => "\xF0\x90\x93\xB5",
		"\xF0\x90\x93\x8E" => "\xF0\x90\x93\xB6",
		"\xF0\x90\x93\x8F" => "\xF0\x90\x93\xB7",
		"\xF0\x90\x93\x90" => "\xF0\x90\x93\xB8",
		"\xF0\x90\x93\x91" => "\xF0\x90\x93\xB9",
		"\xF0\x90\x93\x92" => "\xF0\x90\x93\xBA",
		"\xF0\x90\x93\x93" => "\xF0\x90\x93\xBB",
		"\xF0\x90\x95\xB0" => "\xF0\x90\x96\x97",
		"\xF0\x90\x95\xB1" => "\xF0\x90\x96\x98",
		"\xF0\x90\x95\xB2" => "\xF0\x90\x96\x99",
		"\xF0\x90\x95\xB3" => "\xF0\x90\x96\x9A",
		"\xF0\x90\x95\xB4" => "\xF0\x90\x96\x9B",
		"\xF0\x90\x95\xB5" => "\xF0\x90\x96\x9C",
		"\xF0\x90\x95\xB6" => "\xF0\x90\x96\x9D",
		"\xF0\x90\x95\xB7" => "\xF0\x90\x96\x9E",
		"\xF0\x90\x95\xB8" => "\xF0\x90\x96\x9F",
		"\xF0\x90\x95\xB9" => "\xF0\x90\x96\xA0",
		"\xF0\x90\x95\xBA" => "\xF0\x90\x96\xA1",
		"\xF0\x90\x95\xBC" => "\xF0\x90\x96\xA3",
		"\xF0\x90\x95\xBD" => "\xF0\x90\x96\xA4",
		"\xF0\x90\x95\xBE" => "\xF0\x90\x96\xA5",
		"\xF0\x90\x95\xBF" => "\xF0\x90\x96\xA6",
		"\xF0\x90\x96\x80" => "\xF0\x90\x96\xA7",
		"\xF0\x90\x96\x81" => "\xF0\x90\x96\xA8",
		"\xF0\x90\x96\x82" => "\xF0\x90\x96\xA9",
		"\xF0\x90\x96\x83" => "\xF0\x90\x96\xAA",
		"\xF0\x90\x96\x84" => "\xF0\x90\x96\xAB",
		"\xF0\x90\x96\x85" => "\xF0\x90\x96\xAC",
		"\xF0\x90\x96\x86" => "\xF0\x90\x96\xAD",
		"\xF0\x90\x96\x87" => "\xF0\x90\x96\xAE",
		"\xF0\x90\x96\x88" => "\xF0\x90\x96\xAF",
		"\xF0\x90\x96\x89" => "\xF0\x90\x96\xB0",
		"\xF0\x90\x96\x8A" => "\xF0\x90\x96\xB1",
		"\xF0\x90\x96\x8C" => "\xF0\x90\x96\xB3",
		"\xF0\x90\x96\x8D" => "\xF0\x90\x96\xB4",
		"\xF0\x90\x96\x8E" => "\xF0\x90\x96\xB5",
		"\xF0\x90\x96\x8F" => "\xF0\x90\x96\xB6",
		"\xF0\x90\x96\x90" => "\xF0\x90\x96\xB7",
		"\xF0\x90\x96\x91" => "\xF0\x90\x96\xB8",
		"\xF0\x90\x96\x92" => "\xF0\x90\x96\xB9",
		"\xF0\x90\x96\x94" => "\xF0\x90\x96\xBB",
		"\xF0\x90\x96\x95" => "\xF0\x90\x96\xBC",
		"\xF0\x90\xB2\x80" => "\xF0\x90\xB3\x80",
		"\xF0\x90\xB2\x81" => "\xF0\x90\xB3\x81",
		"\xF0\x90\xB2\x82" => "\xF0\x90\xB3\x82",
		"\xF0\x90\xB2\x83" => "\xF0\x90\xB3\x83",
		"\xF0\x90\xB2\x84" => "\xF0\x90\xB3\x84",
		"\xF0\x90\xB2\x85" => "\xF0\x90\xB3\x85",
		"\xF0\x90\xB2\x86" => "\xF0\x90\xB3\x86",
		"\xF0\x90\xB2\x87" => "\xF0\x90\xB3\x87",
		"\xF0\x90\xB2\x88" => "\xF0\x90\xB3\x88",
		"\xF0\x90\xB2\x89" => "\xF0\x90\xB3\x89",
		"\xF0\x90\xB2\x8A" => "\xF0\x90\xB3\x8A",
		"\xF0\x90\xB2\x8B" => "\xF0\x90\xB3\x8B",
		"\xF0\x90\xB2\x8C" => "\xF0\x90\xB3\x8C",
		"\xF0\x90\xB2\x8D" => "\xF0\x90\xB3\x8D",
		"\xF0\x90\xB2\x8E" => "\xF0\x90\xB3\x8E",
		"\xF0\x90\xB2\x8F" => "\xF0\x90\xB3\x8F",
		"\xF0\x90\xB2\x90" => "\xF0\x90\xB3\x90",
		"\xF0\x90\xB2\x91" => "\xF0\x90\xB3\x91",
		"\xF0\x90\xB2\x92" => "\xF0\x90\xB3\x92",
		"\xF0\x90\xB2\x93" => "\xF0\x90\xB3\x93",
		"\xF0\x90\xB2\x94" => "\xF0\x90\xB3\x94",
		"\xF0\x90\xB2\x95" => "\xF0\x90\xB3\x95",
		"\xF0\x90\xB2\x96" => "\xF0\x90\xB3\x96",
		"\xF0\x90\xB2\x97" => "\xF0\x90\xB3\x97",
		"\xF0\x90\xB2\x98" => "\xF0\x90\xB3\x98",
		"\xF0\x90\xB2\x99" => "\xF0\x90\xB3\x99",
		"\xF0\x90\xB2\x9A" => "\xF0\x90\xB3\x9A",
		"\xF0\x90\xB2\x9B" => "\xF0\x90\xB3\x9B",
		"\xF0\x90\xB2\x9C" => "\xF0\x90\xB3\x9C",
		"\xF0\x90\xB2\x9D" => "\xF0\x90\xB3\x9D",
		"\xF0\x90\xB2\x9E" => "\xF0\x90\xB3\x9E",
		"\xF0\x90\xB2\x9F" => "\xF0\x90\xB3\x9F",
		"\xF0\x90\xB2\xA0" => "\xF0\x90\xB3\xA0",
		"\xF0\x90\xB2\xA1" => "\xF0\x90\xB3\xA1",
		"\xF0\x90\xB2\xA2" => "\xF0\x90\xB3\xA2",
		"\xF0\x90\xB2\xA3" => "\xF0\x90\xB3\xA3",
		"\xF0\x90\xB2\xA4" => "\xF0\x90\xB3\xA4",
		"\xF0\x90\xB2\xA5" => "\xF0\x90\xB3\xA5",
		"\xF0\x90\xB2\xA6" => "\xF0\x90\xB3\xA6",
		"\xF0\x90\xB2\xA7" => "\xF0\x90\xB3\xA7",
		"\xF0\x90\xB2\xA8" => "\xF0\x90\xB3\xA8",
		"\xF0\x90\xB2\xA9" => "\xF0\x90\xB3\xA9",
		"\xF0\x90\xB2\xAA" => "\xF0\x90\xB3\xAA",
		"\xF0\x90\xB2\xAB" => "\xF0\x90\xB3\xAB",
		"\xF0\x90\xB2\xAC" => "\xF0\x90\xB3\xAC",
		"\xF0\x90\xB2\xAD" => "\xF0\x90\xB3\xAD",
		"\xF0\x90\xB2\xAE" => "\xF0\x90\xB3\xAE",
		"\xF0\x90\xB2\xAF" => "\xF0\x90\xB3\xAF",
		"\xF0\x90\xB2\xB0" => "\xF0\x90\xB3\xB0",
		"\xF0\x90\xB2\xB1" => "\xF0\x90\xB3\xB1",
		"\xF0\x90\xB2\xB2" => "\xF0\x90\xB3\xB2",
		"\xF0\x90\xB5\x90" => "\xF0\x90\xB5\xB0",
		"\xF0\x90\xB5\x91" => "\xF0\x90\xB5\xB1",
		"\xF0\x90\xB5\x92" => "\xF0\x90\xB5\xB2",
		"\xF0\x90\xB5\x93" => "\xF0\x90\xB5\xB3",
		"\xF0\x90\xB5\x94" => "\xF0\x90\xB5\xB4",
		"\xF0\x90\xB5\x95" => "\xF0\x90\xB5\xB5",
		"\xF0\x90\xB5\x96" => "\xF0\x90\xB5\xB6",
		"\xF0\x90\xB5\x97" => "\xF0\x90\xB5\xB7",
		"\xF0\x90\xB5\x98" => "\xF0\x90\xB5\xB8",
		"\xF0\x90\xB5\x99" => "\xF0\x90\xB5\xB9",
		"\xF0\x90\xB5\x9A" => "\xF0\x90\xB5\xBA",
		"\xF0\x90\xB5\x9B" => "\xF0\x90\xB5\xBB",
		"\xF0\x90\xB5\x9C" => "\xF0\x90\xB5\xBC",
		"\xF0\x90\xB5\x9D" => "\xF0\x90\xB5\xBD",
		"\xF0\x90\xB5\x9E" => "\xF0\x90\xB5\xBE",
		"\xF0\x90\xB5\x9F" => "\xF0\x90\xB5\xBF",
		"\xF0\x90\xB5\xA0" => "\xF0\x90\xB6\x80",
		"\xF0\x90\xB5\xA1" => "\xF0\x90\xB6\x81",
		"\xF0\x90\xB5\xA2" => "\xF0\x90\xB6\x82",
		"\xF0\x90\xB5\xA3" => "\xF0\x90\xB6\x83",
		"\xF0\x90\xB5\xA4" => "\xF0\x90\xB6\x84",
		"\xF0\x90\xB5\xA5" => "\xF0\x90\xB6\x85",
		"\xF0\x91\xA2\xA0" => "\xF0\x91\xA3\x80",
		"\xF0\x91\xA2\xA1" => "\xF0\x91\xA3\x81",
		"\xF0\x91\xA2\xA2" => "\xF0\x91\xA3\x82",
		"\xF0\x91\xA2\xA3" => "\xF0\x91\xA3\x83",
		"\xF0\x91\xA2\xA4" => "\xF0\x91\xA3\x84",
		"\xF0\x91\xA2\xA5" => "\xF0\x91\xA3\x85",
		"\xF0\x91\xA2\xA6" => "\xF0\x91\xA3\x86",
		"\xF0\x91\xA2\xA7" => "\xF0\x91\xA3\x87",
		"\xF0\x91\xA2\xA8" => "\xF0\x91\xA3\x88",
		"\xF0\x91\xA2\xA9" => "\xF0\x91\xA3\x89",
		"\xF0\x91\xA2\xAA" => "\xF0\x91\xA3\x8A",
		"\xF0\x91\xA2\xAB" => "\xF0\x91\xA3\x8B",
		"\xF0\x91\xA2\xAC" => "\xF0\x91\xA3\x8C",
		"\xF0\x91\xA2\xAD" => "\xF0\x91\xA3\x8D",
		"\xF0\x91\xA2\xAE" => "\xF0\x91\xA3\x8E",
		"\xF0\x91\xA2\xAF" => "\xF0\x91\xA3\x8F",
		"\xF0\x91\xA2\xB0" => "\xF0\x91\xA3\x90",
		"\xF0\x91\xA2\xB1" => "\xF0\x91\xA3\x91",
		"\xF0\x91\xA2\xB2" => "\xF0\x91\xA3\x92",
		"\xF0\x91\xA2\xB3" => "\xF0\x91\xA3\x93",
		"\xF0\x91\xA2\xB4" => "\xF0\x91\xA3\x94",
		"\xF0\x91\xA2\xB5" => "\xF0\x91\xA3\x95",
		"\xF0\x91\xA2\xB6" => "\xF0\x91\xA3\x96",
		"\xF0\x91\xA2\xB7" => "\xF0\x91\xA3\x97",
		"\xF0\x91\xA2\xB8" => "\xF0\x91\xA3\x98",
		"\xF0\x91\xA2\xB9" => "\xF0\x91\xA3\x99",
		"\xF0\x91\xA2\xBA" => "\xF0\x91\xA3\x9A",
		"\xF0\x91\xA2\xBB" => "\xF0\x91\xA3\x9B",
		"\xF0\x91\xA2\xBC" => "\xF0\x91\xA3\x9C",
		"\xF0\x91\xA2\xBD" => "\xF0\x91\xA3\x9D",
		"\xF0\x91\xA2\xBE" => "\xF0\x91\xA3\x9E",
		"\xF0\x91\xA2\xBF" => "\xF0\x91\xA3\x9F",
		"\xF0\x96\xB9\x80" => "\xF0\x96\xB9\xA0",
		"\xF0\x96\xB9\x81" => "\xF0\x96\xB9\xA1",
		"\xF0\x96\xB9\x82" => "\xF0\x96\xB9\xA2",
		"\xF0\x96\xB9\x83" => "\xF0\x96\xB9\xA3",
		"\xF0\x96\xB9\x84" => "\xF0\x96\xB9\xA4",
		"\xF0\x96\xB9\x85" => "\xF0\x96\xB9\xA5",
		"\xF0\x96\xB9\x86" => "\xF0\x96\xB9\xA6",
		"\xF0\x96\xB9\x87" => "\xF0\x96\xB9\xA7",
		"\xF0\x96\xB9\x88" => "\xF0\x96\xB9\xA8",
		"\xF0\x96\xB9\x89" => "\xF0\x96\xB9\xA9",
		"\xF0\x96\xB9\x8A" => "\xF0\x96\xB9\xAA",
		"\xF0\x96\xB9\x8B" => "\xF0\x96\xB9\xAB",
		"\xF0\x96\xB9\x8C" => "\xF0\x96\xB9\xAC",
		"\xF0\x96\xB9\x8D" => "\xF0\x96\xB9\xAD",
		"\xF0\x96\xB9\x8E" => "\xF0\x96\xB9\xAE",
		"\xF0\x96\xB9\x8F" => "\xF0\x96\xB9\xAF",
		"\xF0\x96\xB9\x90" => "\xF0\x96\xB9\xB0",
		"\xF0\x96\xB9\x91" => "\xF0\x96\xB9\xB1",
		"\xF0\x96\xB9\x92" => "\xF0\x96\xB9\xB2",
		"\xF0\x96\xB9\x93" => "\xF0\x96\xB9\xB3",
		"\xF0\x96\xB9\x94" => "\xF0\x96\xB9\xB4",
		"\xF0\x96\xB9\x95" => "\xF0\x96\xB9\xB5",
		"\xF0\x96\xB9\x96" => "\xF0\x96\xB9\xB6",
		"\xF0\x96\xB9\x97" => "\xF0\x96\xB9\xB7",
		"\xF0\x96\xB9\x98" => "\xF0\x96\xB9\xB8",
		"\xF0\x96\xB9\x99" => "\xF0\x96\xB9\xB9",
		"\xF0\x96\xB9\x9A" => "\xF0\x96\xB9\xBA",
		"\xF0\x96\xB9\x9B" => "\xF0\x96\xB9\xBB",
		"\xF0\x96\xB9\x9C" => "\xF0\x96\xB9\xBC",
		"\xF0\x96\xB9\x9D" => "\xF0\x96\xB9\xBD",
		"\xF0\x96\xB9\x9E" => "\xF0\x96\xB9\xBE",
		"\xF0\x96\xB9\x9F" => "\xF0\x96\xB9\xBF",
		"\xF0\x96\xBA\xA0" => "\xF0\x96\xBA\xBB",
		"\xF0\x96\xBA\xA1" => "\xF0\x96\xBA\xBC",
		"\xF0\x96\xBA\xA2" => "\xF0\x96\xBA\xBD",
		"\xF0\x96\xBA\xA3" => "\xF0\x96\xBA\xBE",
		"\xF0\x96\xBA\xA4" => "\xF0\x96\xBA\xBF",
		"\xF0\x96\xBA\xA5" => "\xF0\x96\xBB\x80",
		"\xF0\x96\xBA\xA6" => "\xF0\x96\xBB\x81",
		"\xF0\x96\xBA\xA7" => "\xF0\x96\xBB\x82",
		"\xF0\x96\xBA\xA8" => "\xF0\x96\xBB\x83",
		"\xF0\x96\xBA\xA9" => "\xF0\x96\xBB\x84",
		"\xF0\x96\xBA\xAA" => "\xF0\x96\xBB\x85",
		"\xF0\x96\xBA\xAB" => "\xF0\x96\xBB\x86",
		"\xF0\x96\xBA\xAC" => "\xF0\x96\xBB\x87",
		"\xF0\x96\xBA\xAD" => "\xF0\x96\xBB\x88",
		"\xF0\x96\xBA\xAE" => "\xF0\x96\xBB\x89",
		"\xF0\x96\xBA\xAF" => "\xF0\x96\xBB\x8A",
		"\xF0\x96\xBA\xB0" => "\xF0\x96\xBB\x8B",
		"\xF0\x96\xBA\xB1" => "\xF0\x96\xBB\x8C",
		"\xF0\x96\xBA\xB2" => "\xF0\x96\xBB\x8D",
		"\xF0\x96\xBA\xB3" => "\xF0\x96\xBB\x8E",
		"\xF0\x96\xBA\xB4" => "\xF0\x96\xBB\x8F",
		"\xF0\x96\xBA\xB5" => "\xF0\x96\xBB\x90",
		"\xF0\x96\xBA\xB6" => "\xF0\x96\xBB\x91",
		"\xF0\x96\xBA\xB7" => "\xF0\x96\xBB\x92",
		"\xF0\x96\xBA\xB8" => "\xF0\x96\xBB\x93",
		"\xF0\x9E\xA4\x80" => "\xF0\x9E\xA4\xA2",
		"\xF0\x9E\xA4\x81" => "\xF0\x9E\xA4\xA3",
		"\xF0\x9E\xA4\x82" => "\xF0\x9E\xA4\xA4",
		"\xF0\x9E\xA4\x83" => "\xF0\x9E\xA4\xA5",
		"\xF0\x9E\xA4\x84" => "\xF0\x9E\xA4\xA6",
		"\xF0\x9E\xA4\x85" => "\xF0\x9E\xA4\xA7",
		"\xF0\x9E\xA4\x86" => "\xF0\x9E\xA4\xA8",
		"\xF0\x9E\xA4\x87" => "\xF0\x9E\xA4\xA9",
		"\xF0\x9E\xA4\x88" => "\xF0\x9E\xA4\xAA",
		"\xF0\x9E\xA4\x89" => "\xF0\x9E\xA4\xAB",
		"\xF0\x9E\xA4\x8A" => "\xF0\x9E\xA4\xAC",
		"\xF0\x9E\xA4\x8B" => "\xF0\x9E\xA4\xAD",
		"\xF0\x9E\xA4\x8C" => "\xF0\x9E\xA4\xAE",
		"\xF0\x9E\xA4\x8D" => "\xF0\x9E\xA4\xAF",
		"\xF0\x9E\xA4\x8E" => "\xF0\x9E\xA4\xB0",
		"\xF0\x9E\xA4\x8F" => "\xF0\x9E\xA4\xB1",
		"\xF0\x9E\xA4\x90" => "\xF0\x9E\xA4\xB2",
		"\xF0\x9E\xA4\x91" => "\xF0\x9E\xA4\xB3",
		"\xF0\x9E\xA4\x92" => "\xF0\x9E\xA4\xB4",
		"\xF0\x9E\xA4\x93" => "\xF0\x9E\xA4\xB5",
		"\xF0\x9E\xA4\x94" => "\xF0\x9E\xA4\xB6",
		"\xF0\x9E\xA4\x95" => "\xF0\x9E\xA4\xB7",
		"\xF0\x9E\xA4\x96" => "\xF0\x9E\xA4\xB8",
		"\xF0\x9E\xA4\x97" => "\xF0\x9E\xA4\xB9",
		"\xF0\x9E\xA4\x98" => "\xF0\x9E\xA4\xBA",
		"\xF0\x9E\xA4\x99" => "\xF0\x9E\xA4\xBB",
		"\xF0\x9E\xA4\x9A" => "\xF0\x9E\xA4\xBC",
		"\xF0\x9E\xA4\x9B" => "\xF0\x9E\xA4\xBD",
		"\xF0\x9E\xA4\x9C" => "\xF0\x9E\xA4\xBE",
		"\xF0\x9E\xA4\x9D" => "\xF0\x9E\xA4\xBF",
		"\xF0\x9E\xA4\x9E" => "\xF0\x9E\xA5\x80",
		"\xF0\x9E\xA4\x9F" => "\xF0\x9E\xA5\x81",
		"\xF0\x9E\xA4\xA0" => "\xF0\x9E\xA5\x82",
		"\xF0\x9E\xA4\xA1" => "\xF0\x9E\xA5\x83",
	);
}

/**
 * Helper function for utf8_strtolower.
 *
 * Developers: Do not update the data in this function manually. Instead,
 * run "php -f other/update_unicode_data.php" on the command line.
 *
 * @return array Uppercase to lowercase maps.
 */
function utf8_strtolower_maps()
{
	return array(
		"\x41" => "\x61",
		"\x42" => "\x62",
		"\x43" => "\x63",
		"\x44" => "\x64",
		"\x45" => "\x65",
		"\x46" => "\x66",
		"\x47" => "\x67",
		"\x48" => "\x68",
		"\x49" => "\x69",
		"\x4A" => "\x6A",
		"\x4B" => "\x6B",
		"\x4C" => "\x6C",
		"\x4D" => "\x6D",
		"\x4E" => "\x6E",
		"\x4F" => "\x6F",
		"\x50" => "\x70",
		"\x51" => "\x71",
		"\x52" => "\x72",
		"\x53" => "\x73",
		"\x54" => "\x74",
		"\x55" => "\x75",
		"\x56" => "\x76",
		"\x57" => "\x77",
		"\x58" => "\x78",
		"\x59" => "\x79",
		"\x5A" => "\x7A",
		"\xC3\x80" => "\xC3\xA0",
		"\xC3\x81" => "\xC3\xA1",
		"\xC3\x82" => "\xC3\xA2",
		"\xC3\x83" => "\xC3\xA3",
		"\xC3\x84" => "\xC3\xA4",
		"\xC3\x85" => "\xC3\xA5",
		"\xC3\x86" => "\xC3\xA6",
		"\xC3\x87" => "\xC3\xA7",
		"\xC3\x88" => "\xC3\xA8",
		"\xC3\x89" => "\xC3\xA9",
		"\xC3\x8A" => "\xC3\xAA",
		"\xC3\x8B" => "\xC3\xAB",
		"\xC3\x8C" => "\xC3\xAC",
		"\xC3\x8D" => "\xC3\xAD",
		"\xC3\x8E" => "\xC3\xAE",
		"\xC3\x8F" => "\xC3\xAF",
		"\xC3\x90" => "\xC3\xB0",
		"\xC3\x91" => "\xC3\xB1",
		"\xC3\x92" => "\xC3\xB2",
		"\xC3\x93" => "\xC3\xB3",
		"\xC3\x94" => "\xC3\xB4",
		"\xC3\x95" => "\xC3\xB5",
		"\xC3\x96" => "\xC3\xB6",
		"\xC3\x98" => "\xC3\xB8",
		"\xC3\x99" => "\xC3\xB9",
		"\xC3\x9A" => "\xC3\xBA",
		"\xC3\x9B" => "\xC3\xBB",
		"\xC3\x9C" => "\xC3\xBC",
		"\xC3\x9D" => "\xC3\xBD",
		"\xC3\x9E" => "\xC3\xBE",
		"\xC3\x9F" => "\xC3\x9F",
		"\xC4\x80" => "\xC4\x81",
		"\xC4\x82" => "\xC4\x83",
		"\xC4\x84" => "\xC4\x85",
		"\xC4\x86" => "\xC4\x87",
		"\xC4\x88" => "\xC4\x89",
		"\xC4\x8A" => "\xC4\x8B",
		"\xC4\x8C" => "\xC4\x8D",
		"\xC4\x8E" => "\xC4\x8F",
		"\xC4\x90" => "\xC4\x91",
		"\xC4\x92" => "\xC4\x93",
		"\xC4\x94" => "\xC4\x95",
		"\xC4\x96" => "\xC4\x97",
		"\xC4\x98" => "\xC4\x99",
		"\xC4\x9A" => "\xC4\x9B",
		"\xC4\x9C" => "\xC4\x9D",
		"\xC4\x9E" => "\xC4\x9F",
		"\xC4\xA0" => "\xC4\xA1",
		"\xC4\xA2" => "\xC4\xA3",
		"\xC4\xA4" => "\xC4\xA5",
		"\xC4\xA6" => "\xC4\xA7",
		"\xC4\xA8" => "\xC4\xA9",
		"\xC4\xAA" => "\xC4\xAB",
		"\xC4\xAC" => "\xC4\xAD",
		"\xC4\xAE" => "\xC4\xAF",
		"\xC4\xB0" => "\x69\xCC\x87",
		"\xC4\xB2" => "\xC4\xB3",
		"\xC4\xB4" => "\xC4\xB5",
		"\xC4\xB6" => "\xC4\xB7",
		"\xC4\xB9" => "\xC4\xBA",
		"\xC4\xBB" => "\xC4\xBC",
		"\xC4\xBD" => "\xC4\xBE",
		"\xC4\xBF" => "\xC5\x80",
		"\xC5\x81" => "\xC5\x82",
		"\xC5\x83" => "\xC5\x84",
		"\xC5\x85" => "\xC5\x86",
		"\xC5\x87" => "\xC5\x88",
		"\xC5\x89" => "\xC5\x89",
		"\xC5\x8A" => "\xC5\x8B",
		"\xC5\x8C" => "\xC5\x8D",
		"\xC5\x8E" => "\xC5\x8F",
		"\xC5\x90" => "\xC5\x91",
		"\xC5\x92" => "\xC5\x93",
		"\xC5\x94" => "\xC5\x95",
		"\xC5\x96" => "\xC5\x97",
		"\xC5\x98" => "\xC5\x99",
		"\xC5\x9A" => "\xC5\x9B",
		"\xC5\x9C" => "\xC5\x9D",
		"\xC5\x9E" => "\xC5\x9F",
		"\xC5\xA0" => "\xC5\xA1",
		"\xC5\xA2" => "\xC5\xA3",
		"\xC5\xA4" => "\xC5\xA5",
		"\xC5\xA6" => "\xC5\xA7",
		"\xC5\xA8" => "\xC5\xA9",
		"\xC5\xAA" => "\xC5\xAB",
		"\xC5\xAC" => "\xC5\xAD",
		"\xC5\xAE" => "\xC5\xAF",
		"\xC5\xB0" => "\xC5\xB1",
		"\xC5\xB2" => "\xC5\xB3",
		"\xC5\xB4" => "\xC5\xB5",
		"\xC5\xB6" => "\xC5\xB7",
		"\xC5\xB8" => "\xC3\xBF",
		"\xC5\xB9" => "\xC5\xBA",
		"\xC5\xBB" => "\xC5\xBC",
		"\xC5\xBD" => "\xC5\xBE",
		"\xC6\x81" => "\xC9\x93",
		"\xC6\x82" => "\xC6\x83",
		"\xC6\x84" => "\xC6\x85",
		"\xC6\x86" => "\xC9\x94",
		"\xC6\x87" => "\xC6\x88",
		"\xC6\x89" => "\xC9\x96",
		"\xC6\x8A" => "\xC9\x97",
		"\xC6\x8B" => "\xC6\x8C",
		"\xC6\x8E" => "\xC7\x9D",
		"\xC6\x8F" => "\xC9\x99",
		"\xC6\x90" => "\xC9\x9B",
		"\xC6\x91" => "\xC6\x92",
		"\xC6\x93" => "\xC9\xA0",
		"\xC6\x94" => "\xC9\xA3",
		"\xC6\x96" => "\xC9\xA9",
		"\xC6\x97" => "\xC9\xA8",
		"\xC6\x98" => "\xC6\x99",
		"\xC6\x9C" => "\xC9\xAF",
		"\xC6\x9D" => "\xC9\xB2",
		"\xC6\x9F" => "\xC9\xB5",
		"\xC6\xA0" => "\xC6\xA1",
		"\xC6\xA2" => "\xC6\xA3",
		"\xC6\xA4" => "\xC6\xA5",
		"\xC6\xA6" => "\xCA\x80",
		"\xC6\xA7" => "\xC6\xA8",
		"\xC6\xA9" => "\xCA\x83",
		"\xC6\xAC" => "\xC6\xAD",
		"\xC6\xAE" => "\xCA\x88",
		"\xC6\xAF" => "\xC6\xB0",
		"\xC6\xB1" => "\xCA\x8A",
		"\xC6\xB2" => "\xCA\x8B",
		"\xC6\xB3" => "\xC6\xB4",
		"\xC6\xB5" => "\xC6\xB6",
		"\xC6\xB7" => "\xCA\x92",
		"\xC6\xB8" => "\xC6\xB9",
		"\xC6\xBC" => "\xC6\xBD",
		"\xC7\x84" => "\xC7\x86",
		"\xC7\x85" => "\xC7\x86",
		"\xC7\x87" => "\xC7\x89",
		"\xC7\x88" => "\xC7\x89",
		"\xC7\x8A" => "\xC7\x8C",
		"\xC7\x8B" => "\xC7\x8C",
		"\xC7\x8D" => "\xC7\x8E",
		"\xC7\x8F" => "\xC7\x90",
		"\xC7\x91" => "\xC7\x92",
		"\xC7\x93" => "\xC7\x94",
		"\xC7\x95" => "\xC7\x96",
		"\xC7\x97" => "\xC7\x98",
		"\xC7\x99" => "\xC7\x9A",
		"\xC7\x9B" => "\xC7\x9C",
		"\xC7\x9E" => "\xC7\x9F",
		"\xC7\xA0" => "\xC7\xA1",
		"\xC7\xA2" => "\xC7\xA3",
		"\xC7\xA4" => "\xC7\xA5",
		"\xC7\xA6" => "\xC7\xA7",
		"\xC7\xA8" => "\xC7\xA9",
		"\xC7\xAA" => "\xC7\xAB",
		"\xC7\xAC" => "\xC7\xAD",
		"\xC7\xAE" => "\xC7\xAF",
		"\xC7\xB0" => "\xC7\xB0",
		"\xC7\xB1" => "\xC7\xB3",
		"\xC7\xB2" => "\xC7\xB3",
		"\xC7\xB4" => "\xC7\xB5",
		"\xC7\xB6" => "\xC6\x95",
		"\xC7\xB7" => "\xC6\xBF",
		"\xC7\xB8" => "\xC7\xB9",
		"\xC7\xBA" => "\xC7\xBB",
		"\xC7\xBC" => "\xC7\xBD",
		"\xC7\xBE" => "\xC7\xBF",
		"\xC8\x80" => "\xC8\x81",
		"\xC8\x82" => "\xC8\x83",
		"\xC8\x84" => "\xC8\x85",
		"\xC8\x86" => "\xC8\x87",
		"\xC8\x88" => "\xC8\x89",
		"\xC8\x8A" => "\xC8\x8B",
		"\xC8\x8C" => "\xC8\x8D",
		"\xC8\x8E" => "\xC8\x8F",
		"\xC8\x90" => "\xC8\x91",
		"\xC8\x92" => "\xC8\x93",
		"\xC8\x94" => "\xC8\x95",
		"\xC8\x96" => "\xC8\x97",
		"\xC8\x98" => "\xC8\x99",
		"\xC8\x9A" => "\xC8\x9B",
		"\xC8\x9C" => "\xC8\x9D",
		"\xC8\x9E" => "\xC8\x9F",
		"\xC8\xA0" => "\xC6\x9E",
		"\xC8\xA2" => "\xC8\xA3",
		"\xC8\xA4" => "\xC8\xA5",
		"\xC8\xA6" => "\xC8\xA7",
		"\xC8\xA8" => "\xC8\xA9",
		"\xC8\xAA" => "\xC8\xAB",
		"\xC8\xAC" => "\xC8\xAD",
		"\xC8\xAE" => "\xC8\xAF",
		"\xC8\xB0" => "\xC8\xB1",
		"\xC8\xB2" => "\xC8\xB3",
		"\xC8\xBA" => "\xE2\xB1\xA5",
		"\xC8\xBB" => "\xC8\xBC",
		"\xC8\xBD" => "\xC6\x9A",
		"\xC8\xBE" => "\xE2\xB1\xA6",
		"\xC9\x81" => "\xC9\x82",
		"\xC9\x83" => "\xC6\x80",
		"\xC9\x84" => "\xCA\x89",
		"\xC9\x85" => "\xCA\x8C",
		"\xC9\x86" => "\xC9\x87",
		"\xC9\x88" => "\xC9\x89",
		"\xC9\x8A" => "\xC9\x8B",
		"\xC9\x8C" => "\xC9\x8D",
		"\xC9\x8E" => "\xC9\x8F",
		"\xCD\xB0" => "\xCD\xB1",
		"\xCD\xB2" => "\xCD\xB3",
		"\xCD\xB6" => "\xCD\xB7",
		"\xCD\xBF" => "\xCF\xB3",
		"\xCE\x86" => "\xCE\xAC",
		"\xCE\x88" => "\xCE\xAD",
		"\xCE\x89" => "\xCE\xAE",
		"\xCE\x8A" => "\xCE\xAF",
		"\xCE\x8C" => "\xCF\x8C",
		"\xCE\x8E" => "\xCF\x8D",
		"\xCE\x8F" => "\xCF\x8E",
		"\xCE\x90" => "\xCE\x90",
		"\xCE\x91" => "\xCE\xB1",
		"\xCE\x92" => "\xCE\xB2",
		"\xCE\x93" => "\xCE\xB3",
		"\xCE\x94" => "\xCE\xB4",
		"\xCE\x95" => "\xCE\xB5",
		"\xCE\x96" => "\xCE\xB6",
		"\xCE\x97" => "\xCE\xB7",
		"\xCE\x98" => "\xCE\xB8",
		"\xCE\x99" => "\xCE\xB9",
		"\xCE\x9A" => "\xCE\xBA",
		"\xCE\x9B" => "\xCE\xBB",
		"\xCE\x9C" => "\xCE\xBC",
		"\xCE\x9D" => "\xCE\xBD",
		"\xCE\x9E" => "\xCE\xBE",
		"\xCE\x9F" => "\xCE\xBF",
		"\xCE\xA0" => "\xCF\x80",
		"\xCE\xA1" => "\xCF\x81",
		"\xCE\xA3" => "\xCF\x83",
		"\xCE\xA4" => "\xCF\x84",
		"\xCE\xA5" => "\xCF\x85",
		"\xCE\xA6" => "\xCF\x86",
		"\xCE\xA7" => "\xCF\x87",
		"\xCE\xA8" => "\xCF\x88",
		"\xCE\xA9" => "\xCF\x89",
		"\xCE\xAA" => "\xCF\x8A",
		"\xCE\xAB" => "\xCF\x8B",
		"\xCE\xB0" => "\xCE\xB0",
		"\xCF\x8F" => "\xCF\x97",
		"\xCF\x98" => "\xCF\x99",
		"\xCF\x9A" => "\xCF\x9B",
		"\xCF\x9C" => "\xCF\x9D",
		"\xCF\x9E" => "\xCF\x9F",
		"\xCF\xA0" => "\xCF\xA1",
		"\xCF\xA2" => "\xCF\xA3",
		"\xCF\xA4" => "\xCF\xA5",
		"\xCF\xA6" => "\xCF\xA7",
		"\xCF\xA8" => "\xCF\xA9",
		"\xCF\xAA" => "\xCF\xAB",
		"\xCF\xAC" => "\xCF\xAD",
		"\xCF\xAE" => "\xCF\xAF",
		"\xCF\xB4" => "\xCE\xB8",
		"\xCF\xB7" => "\xCF\xB8",
		"\xCF\xB9" => "\xCF\xB2",
		"\xCF\xBA" => "\xCF\xBB",
		"\xCF\xBD" => "\xCD\xBB",
		"\xCF\xBE" => "\xCD\xBC",
		"\xCF\xBF" => "\xCD\xBD",
		"\xD0\x80" => "\xD1\x90",
		"\xD0\x81" => "\xD1\x91",
		"\xD0\x82" => "\xD1\x92",
		"\xD0\x83" => "\xD1\x93",
		"\xD0\x84" => "\xD1\x94",
		"\xD0\x85" => "\xD1\x95",
		"\xD0\x86" => "\xD1\x96",
		"\xD0\x87" => "\xD1\x97",
		"\xD0\x88" => "\xD1\x98",
		"\xD0\x89" => "\xD1\x99",
		"\xD0\x8A" => "\xD1\x9A",
		"\xD0\x8B" => "\xD1\x9B",
		"\xD0\x8C" => "\xD1\x9C",
		"\xD0\x8D" => "\xD1\x9D",
		"\xD0\x8E" => "\xD1\x9E",
		"\xD0\x8F" => "\xD1\x9F",
		"\xD0\x90" => "\xD0\xB0",
		"\xD0\x91" => "\xD0\xB1",
		"\xD0\x92" => "\xD0\xB2",
		"\xD0\x93" => "\xD0\xB3",
		"\xD0\x94" => "\xD0\xB4",
		"\xD0\x95" => "\xD0\xB5",
		"\xD0\x96" => "\xD0\xB6",
		"\xD0\x97" => "\xD0\xB7",
		"\xD0\x98" => "\xD0\xB8",
		"\xD0\x99" => "\xD0\xB9",
		"\xD0\x9A" => "\xD0\xBA",
		"\xD0\x9B" => "\xD0\xBB",
		"\xD0\x9C" => "\xD0\xBC",
		"\xD0\x9D" => "\xD0\xBD",
		"\xD0\x9E" => "\xD0\xBE",
		"\xD0\x9F" => "\xD0\xBF",
		"\xD0\xA0" => "\xD1\x80",
		"\xD0\xA1" => "\xD1\x81",
		"\xD0\xA2" => "\xD1\x82",
		"\xD0\xA3" => "\xD1\x83",
		"\xD0\xA4" => "\xD1\x84",
		"\xD0\xA5" => "\xD1\x85",
		"\xD0\xA6" => "\xD1\x86",
		"\xD0\xA7" => "\xD1\x87",
		"\xD0\xA8" => "\xD1\x88",
		"\xD0\xA9" => "\xD1\x89",
		"\xD0\xAA" => "\xD1\x8A",
		"\xD0\xAB" => "\xD1\x8B",
		"\xD0\xAC" => "\xD1\x8C",
		"\xD0\xAD" => "\xD1\x8D",
		"\xD0\xAE" => "\xD1\x8E",
		"\xD0\xAF" => "\xD1\x8F",
		"\xD1\xA0" => "\xD1\xA1",
		"\xD1\xA2" => "\xD1\xA3",
		"\xD1\xA4" => "\xD1\xA5",
		"\xD1\xA6" => "\xD1\xA7",
		"\xD1\xA8" => "\xD1\xA9",
		"\xD1\xAA" => "\xD1\xAB",
		"\xD1\xAC" => "\xD1\xAD",
		"\xD1\xAE" => "\xD1\xAF",
		"\xD1\xB0" => "\xD1\xB1",
		"\xD1\xB2" => "\xD1\xB3",
		"\xD1\xB4" => "\xD1\xB5",
		"\xD1\xB6" => "\xD1\xB7",
		"\xD1\xB8" => "\xD1\xB9",
		"\xD1\xBA" => "\xD1\xBB",
		"\xD1\xBC" => "\xD1\xBD",
		"\xD1\xBE" => "\xD1\xBF",
		"\xD2\x80" => "\xD2\x81",
		"\xD2\x8A" => "\xD2\x8B",
		"\xD2\x8C" => "\xD2\x8D",
		"\xD2\x8E" => "\xD2\x8F",
		"\xD2\x90" => "\xD2\x91",
		"\xD2\x92" => "\xD2\x93",
		"\xD2\x94" => "\xD2\x95",
		"\xD2\x96" => "\xD2\x97",
		"\xD2\x98" => "\xD2\x99",
		"\xD2\x9A" => "\xD2\x9B",
		"\xD2\x9C" => "\xD2\x9D",
		"\xD2\x9E" => "\xD2\x9F",
		"\xD2\xA0" => "\xD2\xA1",
		"\xD2\xA2" => "\xD2\xA3",
		"\xD2\xA4" => "\xD2\xA5",
		"\xD2\xA6" => "\xD2\xA7",
		"\xD2\xA8" => "\xD2\xA9",
		"\xD2\xAA" => "\xD2\xAB",
		"\xD2\xAC" => "\xD2\xAD",
		"\xD2\xAE" => "\xD2\xAF",
		"\xD2\xB0" => "\xD2\xB1",
		"\xD2\xB2" => "\xD2\xB3",
		"\xD2\xB4" => "\xD2\xB5",
		"\xD2\xB6" => "\xD2\xB7",
		"\xD2\xB8" => "\xD2\xB9",
		"\xD2\xBA" => "\xD2\xBB",
		"\xD2\xBC" => "\xD2\xBD",
		"\xD2\xBE" => "\xD2\xBF",
		"\xD3\x80" => "\xD3\x8F",
		"\xD3\x81" => "\xD3\x82",
		"\xD3\x83" => "\xD3\x84",
		"\xD3\x85" => "\xD3\x86",
		"\xD3\x87" => "\xD3\x88",
		"\xD3\x89" => "\xD3\x8A",
		"\xD3\x8B" => "\xD3\x8C",
		"\xD3\x8D" => "\xD3\x8E",
		"\xD3\x90" => "\xD3\x91",
		"\xD3\x92" => "\xD3\x93",
		"\xD3\x94" => "\xD3\x95",
		"\xD3\x96" => "\xD3\x97",
		"\xD3\x98" => "\xD3\x99",
		"\xD3\x9A" => "\xD3\x9B",
		"\xD3\x9C" => "\xD3\x9D",
		"\xD3\x9E" => "\xD3\x9F",
		"\xD3\xA0" => "\xD3\xA1",
		"\xD3\xA2" => "\xD3\xA3",
		"\xD3\xA4" => "\xD3\xA5",
		"\xD3\xA6" => "\xD3\xA7",
		"\xD3\xA8" => "\xD3\xA9",
		"\xD3\xAA" => "\xD3\xAB",
		"\xD3\xAC" => "\xD3\xAD",
		"\xD3\xAE" => "\xD3\xAF",
		"\xD3\xB0" => "\xD3\xB1",
		"\xD3\xB2" => "\xD3\xB3",
		"\xD3\xB4" => "\xD3\xB5",
		"\xD3\xB6" => "\xD3\xB7",
		"\xD3\xB8" => "\xD3\xB9",
		"\xD3\xBA" => "\xD3\xBB",
		"\xD3\xBC" => "\xD3\xBD",
		"\xD3\xBE" => "\xD3\xBF",
		"\xD4\x80" => "\xD4\x81",
		"\xD4\x82" => "\xD4\x83",
		"\xD4\x84" => "\xD4\x85",
		"\xD4\x86" => "\xD4\x87",
		"\xD4\x88" => "\xD4\x89",
		"\xD4\x8A" => "\xD4\x8B",
		"\xD4\x8C" => "\xD4\x8D",
		"\xD4\x8E" => "\xD4\x8F",
		"\xD4\x90" => "\xD4\x91",
		"\xD4\x92" => "\xD4\x93",
		"\xD4\x94" => "\xD4\x95",
		"\xD4\x96" => "\xD4\x97",
		"\xD4\x98" => "\xD4\x99",
		"\xD4\x9A" => "\xD4\x9B",
		"\xD4\x9C" => "\xD4\x9D",
		"\xD4\x9E" => "\xD4\x9F",
		"\xD4\xA0" => "\xD4\xA1",
		"\xD4\xA2" => "\xD4\xA3",
		"\xD4\xA4" => "\xD4\xA5",
		"\xD4\xA6" => "\xD4\xA7",
		"\xD4\xA8" => "\xD4\xA9",
		"\xD4\xAA" => "\xD4\xAB",
		"\xD4\xAC" => "\xD4\xAD",
		"\xD4\xAE" => "\xD4\xAF",
		"\xD4\xB1" => "\xD5\xA1",
		"\xD4\xB2" => "\xD5\xA2",
		"\xD4\xB3" => "\xD5\xA3",
		"\xD4\xB4" => "\xD5\xA4",
		"\xD4\xB5" => "\xD5\xA5",
		"\xD4\xB6" => "\xD5\xA6",
		"\xD4\xB7" => "\xD5\xA7",
		"\xD4\xB8" => "\xD5\xA8",
		"\xD4\xB9" => "\xD5\xA9",
		"\xD4\xBA" => "\xD5\xAA",
		"\xD4\xBB" => "\xD5\xAB",
		"\xD4\xBC" => "\xD5\xAC",
		"\xD4\xBD" => "\xD5\xAD",
		"\xD4\xBE" => "\xD5\xAE",
		"\xD4\xBF" => "\xD5\xAF",
		"\xD5\x80" => "\xD5\xB0",
		"\xD5\x81" => "\xD5\xB1",
		"\xD5\x82" => "\xD5\xB2",
		"\xD5\x83" => "\xD5\xB3",
		"\xD5\x84" => "\xD5\xB4",
		"\xD5\x85" => "\xD5\xB5",
		"\xD5\x86" => "\xD5\xB6",
		"\xD5\x87" => "\xD5\xB7",
		"\xD5\x88" => "\xD5\xB8",
		"\xD5\x89" => "\xD5\xB9",
		"\xD5\x8A" => "\xD5\xBA",
		"\xD5\x8B" => "\xD5\xBB",
		"\xD5\x8C" => "\xD5\xBC",
		"\xD5\x8D" => "\xD5\xBD",
		"\xD5\x8E" => "\xD5\xBE",
		"\xD5\x8F" => "\xD5\xBF",
		"\xD5\x90" => "\xD6\x80",
		"\xD5\x91" => "\xD6\x81",
		"\xD5\x92" => "\xD6\x82",
		"\xD5\x93" => "\xD6\x83",
		"\xD5\x94" => "\xD6\x84",
		"\xD5\x95" => "\xD6\x85",
		"\xD5\x96" => "\xD6\x86",
		"\xD6\x87" => "\xD6\x87",
		"\xF0\x90\x90\x80" => "\xF0\x90\x90\xA8",
		"\xF0\x90\x90\x81" => "\xF0\x90\x90\xA9",
		"\xF0\x90\x90\x82" => "\xF0\x90\x90\xAA",
		"\xF0\x90\x90\x83" => "\xF0\x90\x90\xAB",
		"\xF0\x90\x90\x84" => "\xF0\x90\x90\xAC",
		"\xF0\x90\x90\x85" => "\xF0\x90\x90\xAD",
		"\xF0\x90\x90\x86" => "\xF0\x90\x90\xAE",
		"\xF0\x90\x90\x87" => "\xF0\x90\x90\xAF",
		"\xF0\x90\x90\x88" => "\xF0\x90\x90\xB0",
		"\xF0\x90\x90\x89" => "\xF0\x90\x90\xB1",
		"\xF0\x90\x90\x8A" => "\xF0\x90\x90\xB2",
		"\xF0\x90\x90\x8B" => "\xF0\x90\x90\xB3",
		"\xF0\x90\x90\x8C" => "\xF0\x90\x90\xB4",
		"\xF0\x90\x90\x8D" => "\xF0\x90\x90\xB5",
		"\xF0\x90\x90\x8E" => "\xF0\x90\x90\xB6",
		"\xF0\x90\x90\x8F" => "\xF0\x90\x90\xB7",
		"\xF0\x90\x90\x90" => "\xF0\x90\x90\xB8",
		"\xF0\x90\x90\x91" => "\xF0\x90\x90\xB9",
		"\xF0\x90\x90\x92" => "\xF0\x90\x90\xBA",
		"\xF0\x90\x90\x93" => "\xF0\x90\x90\xBB",
		"\xF0\x90\x90\x94" => "\xF0\x90\x90\xBC",
		"\xF0\x90\x90\x95" => "\xF0\x90\x90\xBD",
		"\xF0\x90\x90\x96" => "\xF0\x90\x90\xBE",
		"\xF0\x90\x90\x97" => "\xF0\x90\x90\xBF",
		"\xF0\x90\x90\x98" => "\xF0\x90\x91\x80",
		"\xF0\x90\x90\x99" => "\xF0\x90\x91\x81",
		"\xF0\x90\x90\x9A" => "\xF0\x90\x91\x82",
		"\xF0\x90\x90\x9B" => "\xF0\x90\x91\x83",
		"\xF0\x90\x90\x9C" => "\xF0\x90\x91\x84",
		"\xF0\x90\x90\x9D" => "\xF0\x90\x91\x85",
		"\xF0\x90\x90\x9E" => "\xF0\x90\x91\x86",
		"\xF0\x90\x90\x9F" => "\xF0\x90\x91\x87",
		"\xF0\x90\x90\xA0" => "\xF0\x90\x91\x88",
		"\xF0\x90\x90\xA1" => "\xF0\x90\x91\x89",
		"\xF0\x90\x90\xA2" => "\xF0\x90\x91\x8A",
		"\xF0\x90\x90\xA3" => "\xF0\x90\x91\x8B",
		"\xF0\x90\x90\xA4" => "\xF0\x90\x91\x8C",
		"\xF0\x90\x90\xA5" => "\xF0\x90\x91\x8D",
		"\xF0\x90\x90\xA6" => "\xF0\x90\x91\x8E",
		"\xF0\x90\x90\xA7" => "\xF0\x90\x91\x8F",
		"\xF0\x90\x92\xB0" => "\xF0\x90\x93\x98",
		"\xF0\x90\x92\xB1" => "\xF0\x90\x93\x99",
		"\xF0\x90\x92\xB2" => "\xF0\x90\x93\x9A",
		"\xF0\x90\x92\xB3" => "\xF0\x90\x93\x9B",
		"\xF0\x90\x92\xB4" => "\xF0\x90\x93\x9C",
		"\xF0\x90\x92\xB5" => "\xF0\x90\x93\x9D",
		"\xF0\x90\x92\xB6" => "\xF0\x90\x93\x9E",
		"\xF0\x90\x92\xB7" => "\xF0\x90\x93\x9F",
		"\xF0\x90\x92\xB8" => "\xF0\x90\x93\xA0",
		"\xF0\x90\x92\xB9" => "\xF0\x90\x93\xA1",
		"\xF0\x90\x92\xBA" => "\xF0\x90\x93\xA2",
		"\xF0\x90\x92\xBB" => "\xF0\x90\x93\xA3",
		"\xF0\x90\x92\xBC" => "\xF0\x90\x93\xA4",
		"\xF0\x90\x92\xBD" => "\xF0\x90\x93\xA5",
		"\xF0\x90\x92\xBE" => "\xF0\x90\x93\xA6",
		"\xF0\x90\x92\xBF" => "\xF0\x90\x93\xA7",
		"\xF0\x90\x93\x80" => "\xF0\x90\x93\xA8",
		"\xF0\x90\x93\x81" => "\xF0\x90\x93\xA9",
		"\xF0\x90\x93\x82" => "\xF0\x90\x93\xAA",
		"\xF0\x90\x93\x83" => "\xF0\x90\x93\xAB",
		"\xF0\x90\x93\x84" => "\xF0\x90\x93\xAC",
		"\xF0\x90\x93\x85" => "\xF0\x90\x93\xAD",
		"\xF0\x90\x93\x86" => "\xF0\x90\x93\xAE",
		"\xF0\x90\x93\x87" => "\xF0\x90\x93\xAF",
		"\xF0\x90\x93\x88" => "\xF0\x90\x93\xB0",
		"\xF0\x90\x93\x89" => "\xF0\x90\x93\xB1",
		"\xF0\x90\x93\x8A" => "\xF0\x90\x93\xB2",
		"\xF0\x90\x93\x8B" => "\xF0\x90\x93\xB3",
		"\xF0\x90\x93\x8C" => "\xF0\x90\x93\xB4",
		"\xF0\x90\x93\x8D" => "\xF0\x90\x93\xB5",
		"\xF0\x90\x93\x8E" => "\xF0\x90\x93\xB6",
		"\xF0\x90\x93\x8F" => "\xF0\x90\x93\xB7",
		"\xF0\x90\x93\x90" => "\xF0\x90\x93\xB8",
		"\xF0\x90\x93\x91" => "\xF0\x90\x93\xB9",
		"\xF0\x90\x93\x92" => "\xF0\x90\x93\xBA",
		"\xF0\x90\x93\x93" => "\xF0\x90\x93\xBB",
		"\xF0\x90\x95\xB0" => "\xF0\x90\x96\x97",
		"\xF0\x90\x95\xB1" => "\xF0\x90\x96\x98",
		"\xF0\x90\x95\xB2" => "\xF0\x90\x96\x99",
		"\xF0\x90\x95\xB3" => "\xF0\x90\x96\x9A",
		"\xF0\x90\x95\xB4" => "\xF0\x90\x96\x9B",
		"\xF0\x90\x95\xB5" => "\xF0\x90\x96\x9C",
		"\xF0\x90\x95\xB6" => "\xF0\x90\x96\x9D",
		"\xF0\x90\x95\xB7" => "\xF0\x90\x96\x9E",
		"\xF0\x90\x95\xB8" => "\xF0\x90\x96\x9F",
		"\xF0\x90\x95\xB9" => "\xF0\x90\x96\xA0",
		"\xF0\x90\x95\xBA" => "\xF0\x90\x96\xA1",
		"\xF0\x90\x95\xBC" => "\xF0\x90\x96\xA3",
		"\xF0\x90\x95\xBD" => "\xF0\x90\x96\xA4",
		"\xF0\x90\x95\xBE" => "\xF0\x90\x96\xA5",
		"\xF0\x90\x95\xBF" => "\xF0\x90\x96\xA6",
		"\xF0\x90\x96\x80" => "\xF0\x90\x96\xA7",
		"\xF0\x90\x96\x81" => "\xF0\x90\x96\xA8",
		"\xF0\x90\x96\x82" => "\xF0\x90\x96\xA9",
		"\xF0\x90\x96\x83" => "\xF0\x90\x96\xAA",
		"\xF0\x90\x96\x84" => "\xF0\x90\x96\xAB",
		"\xF0\x90\x96\x85" => "\xF0\x90\x96\xAC",
		"\xF0\x90\x96\x86" => "\xF0\x90\x96\xAD",
		"\xF0\x90\x96\x87" => "\xF0\x90\x96\xAE",
		"\xF0\x90\x96\x88" => "\xF0\x90\x96\xAF",
		"\xF0\x90\x96\x89" => "\xF0\x90\x96\xB0",
		"\xF0\x90\x96\x8A" => "\xF0\x90\x96\xB1",
		"\xF0\x90\x96\x8C" => "\xF0\x90\x96\xB3",
		"\xF0\x90\x96\x8D" => "\xF0\x90\x96\xB4",
		"\xF0\x90\x96\x8E" => "\xF0\x90\x96\xB5",
		"\xF0\x90\x96\x8F" => "\xF0\x90\x96\xB6",
		"\xF0\x90\x96\x90" => "\xF0\x90\x96\xB7",
		"\xF0\x90\x96\x91" => "\xF0\x90\x96\xB8",
		"\xF0\x90\x96\x92" => "\xF0\x90\x96\xB9",
		"\xF0\x90\x96\x94" => "\xF0\x90\x96\xBB",
		"\xF0\x90\x96\x95" => "\xF0\x90\x96\xBC",
		"\xE1\x82\xA0" => "\xE2\xB4\x80",
		"\xE1\x82\xA1" => "\xE2\xB4\x81",
		"\xE1\x82\xA2" => "\xE2\xB4\x82",
		"\xE1\x82\xA3" => "\xE2\xB4\x83",
		"\xE1\x82\xA4" => "\xE2\xB4\x84",
		"\xE1\x82\xA5" => "\xE2\xB4\x85",
		"\xE1\x82\xA6" => "\xE2\xB4\x86",
		"\xE1\x82\xA7" => "\xE2\xB4\x87",
		"\xE1\x82\xA8" => "\xE2\xB4\x88",
		"\xE1\x82\xA9" => "\xE2\xB4\x89",
		"\xE1\x82\xAA" => "\xE2\xB4\x8A",
		"\xE1\x82\xAB" => "\xE2\xB4\x8B",
		"\xE1\x82\xAC" => "\xE2\xB4\x8C",
		"\xE1\x82\xAD" => "\xE2\xB4\x8D",
		"\xE1\x82\xAE" => "\xE2\xB4\x8E",
		"\xE1\x82\xAF" => "\xE2\xB4\x8F",
		"\xE1\x82\xB0" => "\xE2\xB4\x90",
		"\xE1\x82\xB1" => "\xE2\xB4\x91",
		"\xE1\x82\xB2" => "\xE2\xB4\x92",
		"\xE1\x82\xB3" => "\xE2\xB4\x93",
		"\xE1\x82\xB4" => "\xE2\xB4\x94",
		"\xE1\x82\xB5" => "\xE2\xB4\x95",
		"\xE1\x82\xB6" => "\xE2\xB4\x96",
		"\xE1\x82\xB7" => "\xE2\xB4\x97",
		"\xE1\x82\xB8" => "\xE2\xB4\x98",
		"\xE1\x82\xB9" => "\xE2\xB4\x99",
		"\xE1\x82\xBA" => "\xE2\xB4\x9A",
		"\xE1\x82\xBB" => "\xE2\xB4\x9B",
		"\xE1\x82\xBC" => "\xE2\xB4\x9C",
		"\xE1\x82\xBD" => "\xE2\xB4\x9D",
		"\xE1\x82\xBE" => "\xE2\xB4\x9E",
		"\xE1\x82\xBF" => "\xE2\xB4\x9F",
		"\xE1\x83\x80" => "\xE2\xB4\xA0",
		"\xE1\x83\x81" => "\xE2\xB4\xA1",
		"\xE1\x83\x82" => "\xE2\xB4\xA2",
		"\xE1\x83\x83" => "\xE2\xB4\xA3",
		"\xE1\x83\x84" => "\xE2\xB4\xA4",
		"\xE1\x83\x85" => "\xE2\xB4\xA5",
		"\xE1\x83\x87" => "\xE2\xB4\xA7",
		"\xF0\x90\xB2\x80" => "\xF0\x90\xB3\x80",
		"\xF0\x90\xB2\x81" => "\xF0\x90\xB3\x81",
		"\xF0\x90\xB2\x82" => "\xF0\x90\xB3\x82",
		"\xF0\x90\xB2\x83" => "\xF0\x90\xB3\x83",
		"\xF0\x90\xB2\x84" => "\xF0\x90\xB3\x84",
		"\xF0\x90\xB2\x85" => "\xF0\x90\xB3\x85",
		"\xF0\x90\xB2\x86" => "\xF0\x90\xB3\x86",
		"\xF0\x90\xB2\x87" => "\xF0\x90\xB3\x87",
		"\xF0\x90\xB2\x88" => "\xF0\x90\xB3\x88",
		"\xF0\x90\xB2\x89" => "\xF0\x90\xB3\x89",
		"\xF0\x90\xB2\x8A" => "\xF0\x90\xB3\x8A",
		"\xF0\x90\xB2\x8B" => "\xF0\x90\xB3\x8B",
		"\xF0\x90\xB2\x8C" => "\xF0\x90\xB3\x8C",
		"\xF0\x90\xB2\x8D" => "\xF0\x90\xB3\x8D",
		"\xF0\x90\xB2\x8E" => "\xF0\x90\xB3\x8E",
		"\xF0\x90\xB2\x8F" => "\xF0\x90\xB3\x8F",
		"\xF0\x90\xB2\x90" => "\xF0\x90\xB3\x90",
		"\xF0\x90\xB2\x91" => "\xF0\x90\xB3\x91",
		"\xF0\x90\xB2\x92" => "\xF0\x90\xB3\x92",
		"\xF0\x90\xB2\x93" => "\xF0\x90\xB3\x93",
		"\xF0\x90\xB2\x94" => "\xF0\x90\xB3\x94",
		"\xF0\x90\xB2\x95" => "\xF0\x90\xB3\x95",
		"\xF0\x90\xB2\x96" => "\xF0\x90\xB3\x96",
		"\xF0\x90\xB2\x97" => "\xF0\x90\xB3\x97",
		"\xF0\x90\xB2\x98" => "\xF0\x90\xB3\x98",
		"\xF0\x90\xB2\x99" => "\xF0\x90\xB3\x99",
		"\xF0\x90\xB2\x9A" => "\xF0\x90\xB3\x9A",
		"\xF0\x90\xB2\x9B" => "\xF0\x90\xB3\x9B",
		"\xF0\x90\xB2\x9C" => "\xF0\x90\xB3\x9C",
		"\xF0\x90\xB2\x9D" => "\xF0\x90\xB3\x9D",
		"\xF0\x90\xB2\x9E" => "\xF0\x90\xB3\x9E",
		"\xF0\x90\xB2\x9F" => "\xF0\x90\xB3\x9F",
		"\xF0\x90\xB2\xA0" => "\xF0\x90\xB3\xA0",
		"\xF0\x90\xB2\xA1" => "\xF0\x90\xB3\xA1",
		"\xF0\x90\xB2\xA2" => "\xF0\x90\xB3\xA2",
		"\xF0\x90\xB2\xA3" => "\xF0\x90\xB3\xA3",
		"\xF0\x90\xB2\xA4" => "\xF0\x90\xB3\xA4",
		"\xF0\x90\xB2\xA5" => "\xF0\x90\xB3\xA5",
		"\xF0\x90\xB2\xA6" => "\xF0\x90\xB3\xA6",
		"\xF0\x90\xB2\xA7" => "\xF0\x90\xB3\xA7",
		"\xF0\x90\xB2\xA8" => "\xF0\x90\xB3\xA8",
		"\xF0\x90\xB2\xA9" => "\xF0\x90\xB3\xA9",
		"\xF0\x90\xB2\xAA" => "\xF0\x90\xB3\xAA",
		"\xF0\x90\xB2\xAB" => "\xF0\x90\xB3\xAB",
		"\xF0\x90\xB2\xAC" => "\xF0\x90\xB3\xAC",
		"\xF0\x90\xB2\xAD" => "\xF0\x90\xB3\xAD",
		"\xF0\x90\xB2\xAE" => "\xF0\x90\xB3\xAE",
		"\xF0\x90\xB2\xAF" => "\xF0\x90\xB3\xAF",
		"\xF0\x90\xB2\xB0" => "\xF0\x90\xB3\xB0",
		"\xF0\x90\xB2\xB1" => "\xF0\x90\xB3\xB1",
		"\xF0\x90\xB2\xB2" => "\xF0\x90\xB3\xB2",
		"\xE1\x83\x8D" => "\xE2\xB4\xAD",
		"\xF0\x90\xB5\x90" => "\xF0\x90\xB5\xB0",
		"\xF0\x90\xB5\x91" => "\xF0\x90\xB5\xB1",
		"\xF0\x90\xB5\x92" => "\xF0\x90\xB5\xB2",
		"\xF0\x90\xB5\x93" => "\xF0\x90\xB5\xB3",
		"\xF0\x90\xB5\x94" => "\xF0\x90\xB5\xB4",
		"\xF0\x90\xB5\x95" => "\xF0\x90\xB5\xB5",
		"\xF0\x90\xB5\x96" => "\xF0\x90\xB5\xB6",
		"\xF0\x90\xB5\x97" => "\xF0\x90\xB5\xB7",
		"\xF0\x90\xB5\x98" => "\xF0\x90\xB5\xB8",
		"\xF0\x90\xB5\x99" => "\xF0\x90\xB5\xB9",
		"\xF0\x90\xB5\x9A" => "\xF0\x90\xB5\xBA",
		"\xF0\x90\xB5\x9B" => "\xF0\x90\xB5\xBB",
		"\xF0\x90\xB5\x9C" => "\xF0\x90\xB5\xBC",
		"\xF0\x90\xB5\x9D" => "\xF0\x90\xB5\xBD",
		"\xF0\x90\xB5\x9E" => "\xF0\x90\xB5\xBE",
		"\xF0\x90\xB5\x9F" => "\xF0\x90\xB5\xBF",
		"\xF0\x90\xB5\xA0" => "\xF0\x90\xB6\x80",
		"\xF0\x90\xB5\xA1" => "\xF0\x90\xB6\x81",
		"\xF0\x90\xB5\xA2" => "\xF0\x90\xB6\x82",
		"\xF0\x90\xB5\xA3" => "\xF0\x90\xB6\x83",
		"\xF0\x90\xB5\xA4" => "\xF0\x90\xB6\x84",
		"\xF0\x90\xB5\xA5" => "\xF0\x90\xB6\x85",
		"\xF0\x91\xA2\xA0" => "\xF0\x91\xA3\x80",
		"\xF0\x91\xA2\xA1" => "\xF0\x91\xA3\x81",
		"\xF0\x91\xA2\xA2" => "\xF0\x91\xA3\x82",
		"\xF0\x91\xA2\xA3" => "\xF0\x91\xA3\x83",
		"\xF0\x91\xA2\xA4" => "\xF0\x91\xA3\x84",
		"\xF0\x91\xA2\xA5" => "\xF0\x91\xA3\x85",
		"\xF0\x91\xA2\xA6" => "\xF0\x91\xA3\x86",
		"\xF0\x91\xA2\xA7" => "\xF0\x91\xA3\x87",
		"\xF0\x91\xA2\xA8" => "\xF0\x91\xA3\x88",
		"\xF0\x91\xA2\xA9" => "\xF0\x91\xA3\x89",
		"\xF0\x91\xA2\xAA" => "\xF0\x91\xA3\x8A",
		"\xF0\x91\xA2\xAB" => "\xF0\x91\xA3\x8B",
		"\xF0\x91\xA2\xAC" => "\xF0\x91\xA3\x8C",
		"\xF0\x91\xA2\xAD" => "\xF0\x91\xA3\x8D",
		"\xF0\x91\xA2\xAE" => "\xF0\x91\xA3\x8E",
		"\xF0\x91\xA2\xAF" => "\xF0\x91\xA3\x8F",
		"\xF0\x91\xA2\xB0" => "\xF0\x91\xA3\x90",
		"\xF0\x91\xA2\xB1" => "\xF0\x91\xA3\x91",
		"\xF0\x91\xA2\xB2" => "\xF0\x91\xA3\x92",
		"\xF0\x91\xA2\xB3" => "\xF0\x91\xA3\x93",
		"\xF0\x91\xA2\xB4" => "\xF0\x91\xA3\x94",
		"\xF0\x91\xA2\xB5" => "\xF0\x91\xA3\x95",
		"\xF0\x91\xA2\xB6" => "\xF0\x91\xA3\x96",
		"\xF0\x91\xA2\xB7" => "\xF0\x91\xA3\x97",
		"\xF0\x91\xA2\xB8" => "\xF0\x91\xA3\x98",
		"\xF0\x91\xA2\xB9" => "\xF0\x91\xA3\x99",
		"\xF0\x91\xA2\xBA" => "\xF0\x91\xA3\x9A",
		"\xF0\x91\xA2\xBB" => "\xF0\x91\xA3\x9B",
		"\xF0\x91\xA2\xBC" => "\xF0\x91\xA3\x9C",
		"\xF0\x91\xA2\xBD" => "\xF0\x91\xA3\x9D",
		"\xF0\x91\xA2\xBE" => "\xF0\x91\xA3\x9E",
		"\xF0\x91\xA2\xBF" => "\xF0\x91\xA3\x9F",
		"\xE1\x8E\xA0" => "\xEA\xAD\xB0",
		"\xE1\x8E\xA1" => "\xEA\xAD\xB1",
		"\xE1\x8E\xA2" => "\xEA\xAD\xB2",
		"\xE1\x8E\xA3" => "\xEA\xAD\xB3",
		"\xE1\x8E\xA4" => "\xEA\xAD\xB4",
		"\xE1\x8E\xA5" => "\xEA\xAD\xB5",
		"\xE1\x8E\xA6" => "\xEA\xAD\xB6",
		"\xE1\x8E\xA7" => "\xEA\xAD\xB7",
		"\xE1\x8E\xA8" => "\xEA\xAD\xB8",
		"\xE1\x8E\xA9" => "\xEA\xAD\xB9",
		"\xE1\x8E\xAA" => "\xEA\xAD\xBA",
		"\xE1\x8E\xAB" => "\xEA\xAD\xBB",
		"\xE1\x8E\xAC" => "\xEA\xAD\xBC",
		"\xE1\x8E\xAD" => "\xEA\xAD\xBD",
		"\xE1\x8E\xAE" => "\xEA\xAD\xBE",
		"\xE1\x8E\xAF" => "\xEA\xAD\xBF",
		"\xE1\x8E\xB0" => "\xEA\xAE\x80",
		"\xE1\x8E\xB1" => "\xEA\xAE\x81",
		"\xE1\x8E\xB2" => "\xEA\xAE\x82",
		"\xE1\x8E\xB3" => "\xEA\xAE\x83",
		"\xE1\x8E\xB4" => "\xEA\xAE\x84",
		"\xE1\x8E\xB5" => "\xEA\xAE\x85",
		"\xE1\x8E\xB6" => "\xEA\xAE\x86",
		"\xE1\x8E\xB7" => "\xEA\xAE\x87",
		"\xE1\x8E\xB8" => "\xEA\xAE\x88",
		"\xE1\x8E\xB9" => "\xEA\xAE\x89",
		"\xE1\x8E\xBA" => "\xEA\xAE\x8A",
		"\xE1\x8E\xBB" => "\xEA\xAE\x8B",
		"\xE1\x8E\xBC" => "\xEA\xAE\x8C",
		"\xE1\x8E\xBD" => "\xEA\xAE\x8D",
		"\xE1\x8E\xBE" => "\xEA\xAE\x8E",
		"\xE1\x8E\xBF" => "\xEA\xAE\x8F",
		"\xE1\x8F\x80" => "\xEA\xAE\x90",
		"\xE1\x8F\x81" => "\xEA\xAE\x91",
		"\xE1\x8F\x82" => "\xEA\xAE\x92",
		"\xE1\x8F\x83" => "\xEA\xAE\x93",
		"\xE1\x8F\x84" => "\xEA\xAE\x94",
		"\xE1\x8F\x85" => "\xEA\xAE\x95",
		"\xE1\x8F\x86" => "\xEA\xAE\x96",
		"\xE1\x8F\x87" => "\xEA\xAE\x97",
		"\xE1\x8F\x88" => "\xEA\xAE\x98",
		"\xE1\x8F\x89" => "\xEA\xAE\x99",
		"\xE1\x8F\x8A" => "\xEA\xAE\x9A",
		"\xE1\x8F\x8B" => "\xEA\xAE\x9B",
		"\xE1\x8F\x8C" => "\xEA\xAE\x9C",
		"\xE1\x8F\x8D" => "\xEA\xAE\x9D",
		"\xE1\x8F\x8E" => "\xEA\xAE\x9E",
		"\xE1\x8F\x8F" => "\xEA\xAE\x9F",
		"\xE1\x8F\x90" => "\xEA\xAE\xA0",
		"\xE1\x8F\x91" => "\xEA\xAE\xA1",
		"\xE1\x8F\x92" => "\xEA\xAE\xA2",
		"\xE1\x8F\x93" => "\xEA\xAE\xA3",
		"\xE1\x8F\x94" => "\xEA\xAE\xA4",
		"\xE1\x8F\x95" => "\xEA\xAE\xA5",
		"\xE1\x8F\x96" => "\xEA\xAE\xA6",
		"\xE1\x8F\x97" => "\xEA\xAE\xA7",
		"\xE1\x8F\x98" => "\xEA\xAE\xA8",
		"\xE1\x8F\x99" => "\xEA\xAE\xA9",
		"\xE1\x8F\x9A" => "\xEA\xAE\xAA",
		"\xE1\x8F\x9B" => "\xEA\xAE\xAB",
		"\xE1\x8F\x9C" => "\xEA\xAE\xAC",
		"\xE1\x8F\x9D" => "\xEA\xAE\xAD",
		"\xE1\x8F\x9E" => "\xEA\xAE\xAE",
		"\xE1\x8F\x9F" => "\xEA\xAE\xAF",
		"\xE1\x8F\xA0" => "\xEA\xAE\xB0",
		"\xE1\x8F\xA1" => "\xEA\xAE\xB1",
		"\xE1\x8F\xA2" => "\xEA\xAE\xB2",
		"\xE1\x8F\xA3" => "\xEA\xAE\xB3",
		"\xE1\x8F\xA4" => "\xEA\xAE\xB4",
		"\xE1\x8F\xA5" => "\xEA\xAE\xB5",
		"\xE1\x8F\xA6" => "\xEA\xAE\xB6",
		"\xE1\x8F\xA7" => "\xEA\xAE\xB7",
		"\xE1\x8F\xA8" => "\xEA\xAE\xB8",
		"\xE1\x8F\xA9" => "\xEA\xAE\xB9",
		"\xE1\x8F\xAA" => "\xEA\xAE\xBA",
		"\xE1\x8F\xAB" => "\xEA\xAE\xBB",
		"\xE1\x8F\xAC" => "\xEA\xAE\xBC",
		"\xE1\x8F\xAD" => "\xEA\xAE\xBD",
		"\xE1\x8F\xAE" => "\xEA\xAE\xBE",
		"\xE1\x8F\xAF" => "\xEA\xAE\xBF",
		"\xE1\x8F\xB0" => "\xE1\x8F\xB8",
		"\xE1\x8F\xB1" => "\xE1\x8F\xB9",
		"\xE1\x8F\xB2" => "\xE1\x8F\xBA",
		"\xE1\x8F\xB3" => "\xE1\x8F\xBB",
		"\xE1\x8F\xB4" => "\xE1\x8F\xBC",
		"\xE1\x8F\xB5" => "\xE1\x8F\xBD",
		"\xF0\x96\xB9\x80" => "\xF0\x96\xB9\xA0",
		"\xF0\x96\xB9\x81" => "\xF0\x96\xB9\xA1",
		"\xF0\x96\xB9\x82" => "\xF0\x96\xB9\xA2",
		"\xF0\x96\xB9\x83" => "\xF0\x96\xB9\xA3",
		"\xF0\x96\xB9\x84" => "\xF0\x96\xB9\xA4",
		"\xF0\x96\xB9\x85" => "\xF0\x96\xB9\xA5",
		"\xF0\x96\xB9\x86" => "\xF0\x96\xB9\xA6",
		"\xF0\x96\xB9\x87" => "\xF0\x96\xB9\xA7",
		"\xF0\x96\xB9\x88" => "\xF0\x96\xB9\xA8",
		"\xF0\x96\xB9\x89" => "\xF0\x96\xB9\xA9",
		"\xF0\x96\xB9\x8A" => "\xF0\x96\xB9\xAA",
		"\xF0\x96\xB9\x8B" => "\xF0\x96\xB9\xAB",
		"\xF0\x96\xB9\x8C" => "\xF0\x96\xB9\xAC",
		"\xF0\x96\xB9\x8D" => "\xF0\x96\xB9\xAD",
		"\xF0\x96\xB9\x8E" => "\xF0\x96\xB9\xAE",
		"\xF0\x96\xB9\x8F" => "\xF0\x96\xB9\xAF",
		"\xF0\x96\xB9\x90" => "\xF0\x96\xB9\xB0",
		"\xF0\x96\xB9\x91" => "\xF0\x96\xB9\xB1",
		"\xF0\x96\xB9\x92" => "\xF0\x96\xB9\xB2",
		"\xF0\x96\xB9\x93" => "\xF0\x96\xB9\xB3",
		"\xF0\x96\xB9\x94" => "\xF0\x96\xB9\xB4",
		"\xF0\x96\xB9\x95" => "\xF0\x96\xB9\xB5",
		"\xF0\x96\xB9\x96" => "\xF0\x96\xB9\xB6",
		"\xF0\x96\xB9\x97" => "\xF0\x96\xB9\xB7",
		"\xF0\x96\xB9\x98" => "\xF0\x96\xB9\xB8",
		"\xF0\x96\xB9\x99" => "\xF0\x96\xB9\xB9",
		"\xF0\x96\xB9\x9A" => "\xF0\x96\xB9\xBA",
		"\xF0\x96\xB9\x9B" => "\xF0\x96\xB9\xBB",
		"\xF0\x96\xB9\x9C" => "\xF0\x96\xB9\xBC",
		"\xF0\x96\xB9\x9D" => "\xF0\x96\xB9\xBD",
		"\xF0\x96\xB9\x9E" => "\xF0\x96\xB9\xBE",
		"\xF0\x96\xB9\x9F" => "\xF0\x96\xB9\xBF",
		"\xF0\x96\xBA\xA0" => "\xF0\x96\xBA\xBB",
		"\xF0\x96\xBA\xA1" => "\xF0\x96\xBA\xBC",
		"\xF0\x96\xBA\xA2" => "\xF0\x96\xBA\xBD",
		"\xF0\x96\xBA\xA3" => "\xF0\x96\xBA\xBE",
		"\xF0\x96\xBA\xA4" => "\xF0\x96\xBA\xBF",
		"\xF0\x96\xBA\xA5" => "\xF0\x96\xBB\x80",
		"\xF0\x96\xBA\xA6" => "\xF0\x96\xBB\x81",
		"\xF0\x96\xBA\xA7" => "\xF0\x96\xBB\x82",
		"\xF0\x96\xBA\xA8" => "\xF0\x96\xBB\x83",
		"\xF0\x96\xBA\xA9" => "\xF0\x96\xBB\x84",
		"\xF0\x96\xBA\xAA" => "\xF0\x96\xBB\x85",
		"\xF0\x96\xBA\xAB" => "\xF0\x96\xBB\x86",
		"\xF0\x96\xBA\xAC" => "\xF0\x96\xBB\x87",
		"\xF0\x96\xBA\xAD" => "\xF0\x96\xBB\x88",
		"\xF0\x96\xBA\xAE" => "\xF0\x96\xBB\x89",
		"\xF0\x96\xBA\xAF" => "\xF0\x96\xBB\x8A",
		"\xF0\x96\xBA\xB0" => "\xF0\x96\xBB\x8B",
		"\xF0\x96\xBA\xB1" => "\xF0\x96\xBB\x8C",
		"\xF0\x96\xBA\xB2" => "\xF0\x96\xBB\x8D",
		"\xF0\x96\xBA\xB3" => "\xF0\x96\xBB\x8E",
		"\xF0\x96\xBA\xB4" => "\xF0\x96\xBB\x8F",
		"\xF0\x96\xBA\xB5" => "\xF0\x96\xBB\x90",
		"\xF0\x96\xBA\xB6" => "\xF0\x96\xBB\x91",
		"\xF0\x96\xBA\xB7" => "\xF0\x96\xBB\x92",
		"\xF0\x96\xBA\xB8" => "\xF0\x96\xBB\x93",
		"\xE1\xB2\x89" => "\xE1\xB2\x8A",
		"\xE1\xB2\x90" => "\xE1\x83\x90",
		"\xE1\xB2\x91" => "\xE1\x83\x91",
		"\xE1\xB2\x92" => "\xE1\x83\x92",
		"\xE1\xB2\x93" => "\xE1\x83\x93",
		"\xE1\xB2\x94" => "\xE1\x83\x94",
		"\xE1\xB2\x95" => "\xE1\x83\x95",
		"\xE1\xB2\x96" => "\xE1\x83\x96",
		"\xE1\xB2\x97" => "\xE1\x83\x97",
		"\xE1\xB2\x98" => "\xE1\x83\x98",
		"\xE1\xB2\x99" => "\xE1\x83\x99",
		"\xE1\xB2\x9A" => "\xE1\x83\x9A",
		"\xE1\xB2\x9B" => "\xE1\x83\x9B",
		"\xE1\xB2\x9C" => "\xE1\x83\x9C",
		"\xE1\xB2\x9D" => "\xE1\x83\x9D",
		"\xE1\xB2\x9E" => "\xE1\x83\x9E",
		"\xE1\xB2\x9F" => "\xE1\x83\x9F",
		"\xE1\xB2\xA0" => "\xE1\x83\xA0",
		"\xE1\xB2\xA1" => "\xE1\x83\xA1",
		"\xE1\xB2\xA2" => "\xE1\x83\xA2",
		"\xE1\xB2\xA3" => "\xE1\x83\xA3",
		"\xE1\xB2\xA4" => "\xE1\x83\xA4",
		"\xE1\xB2\xA5" => "\xE1\x83\xA5",
		"\xE1\xB2\xA6" => "\xE1\x83\xA6",
		"\xE1\xB2\xA7" => "\xE1\x83\xA7",
		"\xE1\xB2\xA8" => "\xE1\x83\xA8",
		"\xE1\xB2\xA9" => "\xE1\x83\xA9",
		"\xE1\xB2\xAA" => "\xE1\x83\xAA",
		"\xE1\xB2\xAB" => "\xE1\x83\xAB",
		"\xE1\xB2\xAC" => "\xE1\x83\xAC",
		"\xE1\xB2\xAD" => "\xE1\x83\xAD",
		"\xE1\xB2\xAE" => "\xE1\x83\xAE",
		"\xE1\xB2\xAF" => "\xE1\x83\xAF",
		"\xE1\xB2\xB0" => "\xE1\x83\xB0",
		"\xE1\xB2\xB1" => "\xE1\x83\xB1",
		"\xE1\xB2\xB2" => "\xE1\x83\xB2",
		"\xE1\xB2\xB3" => "\xE1\x83\xB3",
		"\xE1\xB2\xB4" => "\xE1\x83\xB4",
		"\xE1\xB2\xB5" => "\xE1\x83\xB5",
		"\xE1\xB2\xB6" => "\xE1\x83\xB6",
		"\xE1\xB2\xB7" => "\xE1\x83\xB7",
		"\xE1\xB2\xB8" => "\xE1\x83\xB8",
		"\xE1\xB2\xB9" => "\xE1\x83\xB9",
		"\xE1\xB2\xBA" => "\xE1\x83\xBA",
		"\xE1\xB2\xBD" => "\xE1\x83\xBD",
		"\xE1\xB2\xBE" => "\xE1\x83\xBE",
		"\xE1\xB2\xBF" => "\xE1\x83\xBF",
		"\xE1\xB8\x80" => "\xE1\xB8\x81",
		"\xE1\xB8\x82" => "\xE1\xB8\x83",
		"\xE1\xB8\x84" => "\xE1\xB8\x85",
		"\xE1\xB8\x86" => "\xE1\xB8\x87",
		"\xE1\xB8\x88" => "\xE1\xB8\x89",
		"\xE1\xB8\x8A" => "\xE1\xB8\x8B",
		"\xE1\xB8\x8C" => "\xE1\xB8\x8D",
		"\xE1\xB8\x8E" => "\xE1\xB8\x8F",
		"\xE1\xB8\x90" => "\xE1\xB8\x91",
		"\xE1\xB8\x92" => "\xE1\xB8\x93",
		"\xE1\xB8\x94" => "\xE1\xB8\x95",
		"\xE1\xB8\x96" => "\xE1\xB8\x97",
		"\xE1\xB8\x98" => "\xE1\xB8\x99",
		"\xE1\xB8\x9A" => "\xE1\xB8\x9B",
		"\xE1\xB8\x9C" => "\xE1\xB8\x9D",
		"\xE1\xB8\x9E" => "\xE1\xB8\x9F",
		"\xE1\xB8\xA0" => "\xE1\xB8\xA1",
		"\xE1\xB8\xA2" => "\xE1\xB8\xA3",
		"\xE1\xB8\xA4" => "\xE1\xB8\xA5",
		"\xE1\xB8\xA6" => "\xE1\xB8\xA7",
		"\xE1\xB8\xA8" => "\xE1\xB8\xA9",
		"\xE1\xB8\xAA" => "\xE1\xB8\xAB",
		"\xE1\xB8\xAC" => "\xE1\xB8\xAD",
		"\xE1\xB8\xAE" => "\xE1\xB8\xAF",
		"\xE1\xB8\xB0" => "\xE1\xB8\xB1",
		"\xE1\xB8\xB2" => "\xE1\xB8\xB3",
		"\xE1\xB8\xB4" => "\xE1\xB8\xB5",
		"\xE1\xB8\xB6" => "\xE1\xB8\xB7",
		"\xE1\xB8\xB8" => "\xE1\xB8\xB9",
		"\xE1\xB8\xBA" => "\xE1\xB8\xBB",
		"\xE1\xB8\xBC" => "\xE1\xB8\xBD",
		"\xE1\xB8\xBE" => "\xE1\xB8\xBF",
		"\xE1\xB9\x80" => "\xE1\xB9\x81",
		"\xE1\xB9\x82" => "\xE1\xB9\x83",
		"\xE1\xB9\x84" => "\xE1\xB9\x85",
		"\xE1\xB9\x86" => "\xE1\xB9\x87",
		"\xE1\xB9\x88" => "\xE1\xB9\x89",
		"\xE1\xB9\x8A" => "\xE1\xB9\x8B",
		"\xE1\xB9\x8C" => "\xE1\xB9\x8D",
		"\xE1\xB9\x8E" => "\xE1\xB9\x8F",
		"\xE1\xB9\x90" => "\xE1\xB9\x91",
		"\xE1\xB9\x92" => "\xE1\xB9\x93",
		"\xE1\xB9\x94" => "\xE1\xB9\x95",
		"\xE1\xB9\x96" => "\xE1\xB9\x97",
		"\xE1\xB9\x98" => "\xE1\xB9\x99",
		"\xE1\xB9\x9A" => "\xE1\xB9\x9B",
		"\xE1\xB9\x9C" => "\xE1\xB9\x9D",
		"\xE1\xB9\x9E" => "\xE1\xB9\x9F",
		"\xE1\xB9\xA0" => "\xE1\xB9\xA1",
		"\xE1\xB9\xA2" => "\xE1\xB9\xA3",
		"\xE1\xB9\xA4" => "\xE1\xB9\xA5",
		"\xE1\xB9\xA6" => "\xE1\xB9\xA7",
		"\xE1\xB9\xA8" => "\xE1\xB9\xA9",
		"\xE1\xB9\xAA" => "\xE1\xB9\xAB",
		"\xE1\xB9\xAC" => "\xE1\xB9\xAD",
		"\xE1\xB9\xAE" => "\xE1\xB9\xAF",
		"\xE1\xB9\xB0" => "\xE1\xB9\xB1",
		"\xE1\xB9\xB2" => "\xE1\xB9\xB3",
		"\xE1\xB9\xB4" => "\xE1\xB9\xB5",
		"\xE1\xB9\xB6" => "\xE1\xB9\xB7",
		"\xE1\xB9\xB8" => "\xE1\xB9\xB9",
		"\xE1\xB9\xBA" => "\xE1\xB9\xBB",
		"\xE1\xB9\xBC" => "\xE1\xB9\xBD",
		"\xE1\xB9\xBE" => "\xE1\xB9\xBF",
		"\xE1\xBA\x80" => "\xE1\xBA\x81",
		"\xE1\xBA\x82" => "\xE1\xBA\x83",
		"\xE1\xBA\x84" => "\xE1\xBA\x85",
		"\xE1\xBA\x86" => "\xE1\xBA\x87",
		"\xE1\xBA\x88" => "\xE1\xBA\x89",
		"\xE1\xBA\x8A" => "\xE1\xBA\x8B",
		"\xE1\xBA\x8C" => "\xE1\xBA\x8D",
		"\xE1\xBA\x8E" => "\xE1\xBA\x8F",
		"\xF0\x9E\xA4\x80" => "\xF0\x9E\xA4\xA2",
		"\xF0\x9E\xA4\x81" => "\xF0\x9E\xA4\xA3",
		"\xF0\x9E\xA4\x82" => "\xF0\x9E\xA4\xA4",
		"\xF0\x9E\xA4\x83" => "\xF0\x9E\xA4\xA5",
		"\xF0\x9E\xA4\x84" => "\xF0\x9E\xA4\xA6",
		"\xF0\x9E\xA4\x85" => "\xF0\x9E\xA4\xA7",
		"\xF0\x9E\xA4\x86" => "\xF0\x9E\xA4\xA8",
		"\xF0\x9E\xA4\x87" => "\xF0\x9E\xA4\xA9",
		"\xF0\x9E\xA4\x88" => "\xF0\x9E\xA4\xAA",
		"\xF0\x9E\xA4\x89" => "\xF0\x9E\xA4\xAB",
		"\xE1\xBA\x90" => "\xE1\xBA\x91",
		"\xF0\x9E\xA4\x8A" => "\xF0\x9E\xA4\xAC",
		"\xF0\x9E\xA4\x8B" => "\xF0\x9E\xA4\xAD",
		"\xF0\x9E\xA4\x8C" => "\xF0\x9E\xA4\xAE",
		"\xF0\x9E\xA4\x8D" => "\xF0\x9E\xA4\xAF",
		"\xF0\x9E\xA4\x8E" => "\xF0\x9E\xA4\xB0",
		"\xF0\x9E\xA4\x8F" => "\xF0\x9E\xA4\xB1",
		"\xF0\x9E\xA4\x90" => "\xF0\x9E\xA4\xB2",
		"\xF0\x9E\xA4\x91" => "\xF0\x9E\xA4\xB3",
		"\xF0\x9E\xA4\x92" => "\xF0\x9E\xA4\xB4",
		"\xF0\x9E\xA4\x93" => "\xF0\x9E\xA4\xB5",
		"\xF0\x9E\xA4\x94" => "\xF0\x9E\xA4\xB6",
		"\xF0\x9E\xA4\x95" => "\xF0\x9E\xA4\xB7",
		"\xF0\x9E\xA4\x96" => "\xF0\x9E\xA4\xB8",
		"\xF0\x9E\xA4\x97" => "\xF0\x9E\xA4\xB9",
		"\xF0\x9E\xA4\x98" => "\xF0\x9E\xA4\xBA",
		"\xF0\x9E\xA4\x99" => "\xF0\x9E\xA4\xBB",
		"\xF0\x9E\xA4\x9A" => "\xF0\x9E\xA4\xBC",
		"\xF0\x9E\xA4\x9B" => "\xF0\x9E\xA4\xBD",
		"\xF0\x9E\xA4\x9C" => "\xF0\x9E\xA4\xBE",
		"\xF0\x9E\xA4\x9D" => "\xF0\x9E\xA4\xBF",
		"\xF0\x9E\xA4\x9E" => "\xF0\x9E\xA5\x80",
		"\xF0\x9E\xA4\x9F" => "\xF0\x9E\xA5\x81",
		"\xF0\x9E\xA4\xA0" => "\xF0\x9E\xA5\x82",
		"\xF0\x9E\xA4\xA1" => "\xF0\x9E\xA5\x83",
		"\xE1\xBA\x92" => "\xE1\xBA\x93",
		"\xE1\xBA\x94" => "\xE1\xBA\x95",
		"\xE1\xBA\x96" => "\xE1\xBA\x96",
		"\xE1\xBA\x97" => "\xE1\xBA\x97",
		"\xE1\xBA\x98" => "\xE1\xBA\x98",
		"\xE1\xBA\x99" => "\xE1\xBA\x99",
		"\xE1\xBA\x9A" => "\xE1\xBA\x9A",
		"\xE1\xBA\x9E" => "\xC3\x9F",
		"\xE1\xBA\xA0" => "\xE1\xBA\xA1",
		"\xE1\xBA\xA2" => "\xE1\xBA\xA3",
		"\xE1\xBA\xA4" => "\xE1\xBA\xA5",
		"\xE1\xBA\xA6" => "\xE1\xBA\xA7",
		"\xE1\xBA\xA8" => "\xE1\xBA\xA9",
		"\xE1\xBA\xAA" => "\xE1\xBA\xAB",
		"\xE1\xBA\xAC" => "\xE1\xBA\xAD",
		"\xE1\xBA\xAE" => "\xE1\xBA\xAF",
		"\xE1\xBA\xB0" => "\xE1\xBA\xB1",
		"\xE1\xBA\xB2" => "\xE1\xBA\xB3",
		"\xE1\xBA\xB4" => "\xE1\xBA\xB5",
		"\xE1\xBA\xB6" => "\xE1\xBA\xB7",
		"\xE1\xBA\xB8" => "\xE1\xBA\xB9",
		"\xE1\xBA\xBA" => "\xE1\xBA\xBB",
		"\xE1\xBA\xBC" => "\xE1\xBA\xBD",
		"\xE1\xBA\xBE" => "\xE1\xBA\xBF",
		"\xE1\xBB\x80" => "\xE1\xBB\x81",
		"\xE1\xBB\x82" => "\xE1\xBB\x83",
		"\xE1\xBB\x84" => "\xE1\xBB\x85",
		"\xE1\xBB\x86" => "\xE1\xBB\x87",
		"\xE1\xBB\x88" => "\xE1\xBB\x89",
		"\xE1\xBB\x8A" => "\xE1\xBB\x8B",
		"\xE1\xBB\x8C" => "\xE1\xBB\x8D",
		"\xE1\xBB\x8E" => "\xE1\xBB\x8F",
		"\xE1\xBB\x90" => "\xE1\xBB\x91",
		"\xE1\xBB\x92" => "\xE1\xBB\x93",
		"\xE1\xBB\x94" => "\xE1\xBB\x95",
		"\xE1\xBB\x96" => "\xE1\xBB\x97",
		"\xE1\xBB\x98" => "\xE1\xBB\x99",
		"\xE1\xBB\x9A" => "\xE1\xBB\x9B",
		"\xE1\xBB\x9C" => "\xE1\xBB\x9D",
		"\xE1\xBB\x9E" => "\xE1\xBB\x9F",
		"\xE1\xBB\xA0" => "\xE1\xBB\xA1",
		"\xE1\xBB\xA2" => "\xE1\xBB\xA3",
		"\xE1\xBB\xA4" => "\xE1\xBB\xA5",
		"\xE1\xBB\xA6" => "\xE1\xBB\xA7",
		"\xE1\xBB\xA8" => "\xE1\xBB\xA9",
		"\xE1\xBB\xAA" => "\xE1\xBB\xAB",
		"\xE1\xBB\xAC" => "\xE1\xBB\xAD",
		"\xE1\xBB\xAE" => "\xE1\xBB\xAF",
		"\xE1\xBB\xB0" => "\xE1\xBB\xB1",
		"\xE1\xBB\xB2" => "\xE1\xBB\xB3",
		"\xE1\xBB\xB4" => "\xE1\xBB\xB5",
		"\xE1\xBB\xB6" => "\xE1\xBB\xB7",
		"\xE1\xBB\xB8" => "\xE1\xBB\xB9",
		"\xE1\xBB\xBA" => "\xE1\xBB\xBB",
		"\xE1\xBB\xBC" => "\xE1\xBB\xBD",
		"\xE1\xBB\xBE" => "\xE1\xBB\xBF",
		"\xE1\xBC\x88" => "\xE1\xBC\x80",
		"\xE1\xBC\x89" => "\xE1\xBC\x81",
		"\xE1\xBC\x8A" => "\xE1\xBC\x82",
		"\xE1\xBC\x8B" => "\xE1\xBC\x83",
		"\xE1\xBC\x8C" => "\xE1\xBC\x84",
		"\xE1\xBC\x8D" => "\xE1\xBC\x85",
		"\xE1\xBC\x8E" => "\xE1\xBC\x86",
		"\xE1\xBC\x8F" => "\xE1\xBC\x87",
		"\xE1\xBC\x98" => "\xE1\xBC\x90",
		"\xE1\xBC\x99" => "\xE1\xBC\x91",
		"\xE1\xBC\x9A" => "\xE1\xBC\x92",
		"\xE1\xBC\x9B" => "\xE1\xBC\x93",
		"\xE1\xBC\x9C" => "\xE1\xBC\x94",
		"\xE1\xBC\x9D" => "\xE1\xBC\x95",
		"\xE1\xBC\xA8" => "\xE1\xBC\xA0",
		"\xE1\xBC\xA9" => "\xE1\xBC\xA1",
		"\xE1\xBC\xAA" => "\xE1\xBC\xA2",
		"\xE1\xBC\xAB" => "\xE1\xBC\xA3",
		"\xE1\xBC\xAC" => "\xE1\xBC\xA4",
		"\xE1\xBC\xAD" => "\xE1\xBC\xA5",
		"\xE1\xBC\xAE" => "\xE1\xBC\xA6",
		"\xE1\xBC\xAF" => "\xE1\xBC\xA7",
		"\xE1\xBC\xB8" => "\xE1\xBC\xB0",
		"\xE1\xBC\xB9" => "\xE1\xBC\xB1",
		"\xE1\xBC\xBA" => "\xE1\xBC\xB2",
		"\xE1\xBC\xBB" => "\xE1\xBC\xB3",
		"\xE1\xBC\xBC" => "\xE1\xBC\xB4",
		"\xE1\xBC\xBD" => "\xE1\xBC\xB5",
		"\xE1\xBC\xBE" => "\xE1\xBC\xB6",
		"\xE1\xBC\xBF" => "\xE1\xBC\xB7",
		"\xE1\xBD\x88" => "\xE1\xBD\x80",
		"\xE1\xBD\x89" => "\xE1\xBD\x81",
		"\xE1\xBD\x8A" => "\xE1\xBD\x82",
		"\xE1\xBD\x8B" => "\xE1\xBD\x83",
		"\xE1\xBD\x8C" => "\xE1\xBD\x84",
		"\xE1\xBD\x8D" => "\xE1\xBD\x85",
		"\xE1\xBD\x90" => "\xE1\xBD\x90",
		"\xE1\xBD\x92" => "\xE1\xBD\x92",
		"\xE1\xBD\x94" => "\xE1\xBD\x94",
		"\xE1\xBD\x96" => "\xE1\xBD\x96",
		"\xE1\xBD\x99" => "\xE1\xBD\x91",
		"\xE1\xBD\x9B" => "\xE1\xBD\x93",
		"\xE1\xBD\x9D" => "\xE1\xBD\x95",
		"\xE1\xBD\x9F" => "\xE1\xBD\x97",
		"\xE1\xBD\xA8" => "\xE1\xBD\xA0",
		"\xE1\xBD\xA9" => "\xE1\xBD\xA1",
		"\xE1\xBD\xAA" => "\xE1\xBD\xA2",
		"\xE1\xBD\xAB" => "\xE1\xBD\xA3",
		"\xE1\xBD\xAC" => "\xE1\xBD\xA4",
		"\xE1\xBD\xAD" => "\xE1\xBD\xA5",
		"\xE1\xBD\xAE" => "\xE1\xBD\xA6",
		"\xE1\xBD\xAF" => "\xE1\xBD\xA7",
		"\xE1\xBE\x80" => "\xE1\xBE\x80",
		"\xE1\xBE\x81" => "\xE1\xBE\x81",
		"\xE1\xBE\x82" => "\xE1\xBE\x82",
		"\xE1\xBE\x83" => "\xE1\xBE\x83",
		"\xE1\xBE\x84" => "\xE1\xBE\x84",
		"\xE1\xBE\x85" => "\xE1\xBE\x85",
		"\xE1\xBE\x86" => "\xE1\xBE\x86",
		"\xE1\xBE\x87" => "\xE1\xBE\x87",
		"\xE1\xBE\x88" => "\xE1\xBE\x80",
		"\xE1\xBE\x89" => "\xE1\xBE\x81",
		"\xE1\xBE\x8A" => "\xE1\xBE\x82",
		"\xE1\xBE\x8B" => "\xE1\xBE\x83",
		"\xE1\xBE\x8C" => "\xE1\xBE\x84",
		"\xE1\xBE\x8D" => "\xE1\xBE\x85",
		"\xE1\xBE\x8E" => "\xE1\xBE\x86",
		"\xE1\xBE\x8F" => "\xE1\xBE\x87",
		"\xE1\xBE\x90" => "\xE1\xBE\x90",
		"\xE1\xBE\x91" => "\xE1\xBE\x91",
		"\xE1\xBE\x92" => "\xE1\xBE\x92",
		"\xE1\xBE\x93" => "\xE1\xBE\x93",
		"\xE1\xBE\x94" => "\xE1\xBE\x94",
		"\xE1\xBE\x95" => "\xE1\xBE\x95",
		"\xE1\xBE\x96" => "\xE1\xBE\x96",
		"\xE1\xBE\x97" => "\xE1\xBE\x97",
		"\xE1\xBE\x98" => "\xE1\xBE\x90",
		"\xE1\xBE\x99" => "\xE1\xBE\x91",
		"\xE1\xBE\x9A" => "\xE1\xBE\x92",
		"\xE1\xBE\x9B" => "\xE1\xBE\x93",
		"\xE1\xBE\x9C" => "\xE1\xBE\x94",
		"\xE1\xBE\x9D" => "\xE1\xBE\x95",
		"\xE1\xBE\x9E" => "\xE1\xBE\x96",
		"\xE1\xBE\x9F" => "\xE1\xBE\x97",
		"\xE1\xBE\xA0" => "\xE1\xBE\xA0",
		"\xE1\xBE\xA1" => "\xE1\xBE\xA1",
		"\xE1\xBE\xA2" => "\xE1\xBE\xA2",
		"\xE1\xBE\xA3" => "\xE1\xBE\xA3",
		"\xE1\xBE\xA4" => "\xE1\xBE\xA4",
		"\xE1\xBE\xA5" => "\xE1\xBE\xA5",
		"\xE1\xBE\xA6" => "\xE1\xBE\xA6",
		"\xE1\xBE\xA7" => "\xE1\xBE\xA7",
		"\xE1\xBE\xA8" => "\xE1\xBE\xA0",
		"\xE1\xBE\xA9" => "\xE1\xBE\xA1",
		"\xE1\xBE\xAA" => "\xE1\xBE\xA2",
		"\xE1\xBE\xAB" => "\xE1\xBE\xA3",
		"\xE1\xBE\xAC" => "\xE1\xBE\xA4",
		"\xE1\xBE\xAD" => "\xE1\xBE\xA5",
		"\xE1\xBE\xAE" => "\xE1\xBE\xA6",
		"\xE1\xBE\xAF" => "\xE1\xBE\xA7",
		"\xE1\xBE\xB2" => "\xE1\xBE\xB2",
		"\xE1\xBE\xB3" => "\xE1\xBE\xB3",
		"\xE1\xBE\xB4" => "\xE1\xBE\xB4",
		"\xE1\xBE\xB6" => "\xE1\xBE\xB6",
		"\xE1\xBE\xB7" => "\xE1\xBE\xB7",
		"\xE1\xBE\xB8" => "\xE1\xBE\xB0",
		"\xE1\xBE\xB9" => "\xE1\xBE\xB1",
		"\xE1\xBE\xBA" => "\xE1\xBD\xB0",
		"\xE1\xBE\xBB" => "\xE1\xBD\xB1",
		"\xE1\xBE\xBC" => "\xE1\xBE\xB3",
		"\xE1\xBF\x82" => "\xE1\xBF\x82",
		"\xE1\xBF\x83" => "\xE1\xBF\x83",
		"\xE1\xBF\x84" => "\xE1\xBF\x84",
		"\xE1\xBF\x86" => "\xE1\xBF\x86",
		"\xE1\xBF\x87" => "\xE1\xBF\x87",
		"\xE1\xBF\x88" => "\xE1\xBD\xB2",
		"\xE1\xBF\x89" => "\xE1\xBD\xB3",
		"\xE1\xBF\x8A" => "\xE1\xBD\xB4",
		"\xE1\xBF\x8B" => "\xE1\xBD\xB5",
		"\xE1\xBF\x8C" => "\xE1\xBF\x83",
		"\xE1\xBF\x92" => "\xE1\xBF\x92",
		"\xE1\xBF\x93" => "\xE1\xBF\x93",
		"\xE1\xBF\x96" => "\xE1\xBF\x96",
		"\xE1\xBF\x97" => "\xE1\xBF\x97",
		"\xE1\xBF\x98" => "\xE1\xBF\x90",
		"\xE1\xBF\x99" => "\xE1\xBF\x91",
		"\xE1\xBF\x9A" => "\xE1\xBD\xB6",
		"\xE1\xBF\x9B" => "\xE1\xBD\xB7",
		"\xE1\xBF\xA2" => "\xE1\xBF\xA2",
		"\xE1\xBF\xA3" => "\xE1\xBF\xA3",
		"\xE1\xBF\xA4" => "\xE1\xBF\xA4",
		"\xE1\xBF\xA6" => "\xE1\xBF\xA6",
		"\xE1\xBF\xA7" => "\xE1\xBF\xA7",
		"\xE1\xBF\xA8" => "\xE1\xBF\xA0",
		"\xE1\xBF\xA9" => "\xE1\xBF\xA1",
		"\xE1\xBF\xAA" => "\xE1\xBD\xBA",
		"\xE1\xBF\xAB" => "\xE1\xBD\xBB",
		"\xE1\xBF\xAC" => "\xE1\xBF\xA5",
		"\xE1\xBF\xB2" => "\xE1\xBF\xB2",
		"\xE1\xBF\xB3" => "\xE1\xBF\xB3",
		"\xE1\xBF\xB4" => "\xE1\xBF\xB4",
		"\xE1\xBF\xB6" => "\xE1\xBF\xB6",
		"\xE1\xBF\xB7" => "\xE1\xBF\xB7",
		"\xE1\xBF\xB8" => "\xE1\xBD\xB8",
		"\xE1\xBF\xB9" => "\xE1\xBD\xB9",
		"\xE1\xBF\xBA" => "\xE1\xBD\xBC",
		"\xE1\xBF\xBB" => "\xE1\xBD\xBD",
		"\xE1\xBF\xBC" => "\xE1\xBF\xB3",
		"\xE2\x84\xA6" => "\xCF\x89",
		"\xE2\x84\xAA" => "\x6B",
		"\xE2\x84\xAB" => "\xC3\xA5",
		"\xE2\x84\xB2" => "\xE2\x85\x8E",
		"\xE2\x85\xA0" => "\xE2\x85\xB0",
		"\xE2\x85\xA1" => "\xE2\x85\xB1",
		"\xE2\x85\xA2" => "\xE2\x85\xB2",
		"\xE2\x85\xA3" => "\xE2\x85\xB3",
		"\xE2\x85\xA4" => "\xE2\x85\xB4",
		"\xE2\x85\xA5" => "\xE2\x85\xB5",
		"\xE2\x85\xA6" => "\xE2\x85\xB6",
		"\xE2\x85\xA7" => "\xE2\x85\xB7",
		"\xE2\x85\xA8" => "\xE2\x85\xB8",
		"\xE2\x85\xA9" => "\xE2\x85\xB9",
		"\xE2\x85\xAA" => "\xE2\x85\xBA",
		"\xE2\x85\xAB" => "\xE2\x85\xBB",
		"\xE2\x85\xAC" => "\xE2\x85\xBC",
		"\xE2\x85\xAD" => "\xE2\x85\xBD",
		"\xE2\x85\xAE" => "\xE2\x85\xBE",
		"\xE2\x85\xAF" => "\xE2\x85\xBF",
		"\xE2\x86\x83" => "\xE2\x86\x84",
		"\xE2\x92\xB6" => "\xE2\x93\x90",
		"\xE2\x92\xB7" => "\xE2\x93\x91",
		"\xE2\x92\xB8" => "\xE2\x93\x92",
		"\xE2\x92\xB9" => "\xE2\x93\x93",
		"\xE2\x92\xBA" => "\xE2\x93\x94",
		"\xE2\x92\xBB" => "\xE2\x93\x95",
		"\xE2\x92\xBC" => "\xE2\x93\x96",
		"\xE2\x92\xBD" => "\xE2\x93\x97",
		"\xE2\x92\xBE" => "\xE2\x93\x98",
		"\xE2\x92\xBF" => "\xE2\x93\x99",
		"\xE2\x93\x80" => "\xE2\x93\x9A",
		"\xE2\x93\x81" => "\xE2\x93\x9B",
		"\xE2\x93\x82" => "\xE2\x93\x9C",
		"\xE2\x93\x83" => "\xE2\x93\x9D",
		"\xE2\x93\x84" => "\xE2\x93\x9E",
		"\xE2\x93\x85" => "\xE2\x93\x9F",
		"\xE2\x93\x86" => "\xE2\x93\xA0",
		"\xE2\x93\x87" => "\xE2\x93\xA1",
		"\xE2\x93\x88" => "\xE2\x93\xA2",
		"\xE2\x93\x89" => "\xE2\x93\xA3",
		"\xE2\x93\x8A" => "\xE2\x93\xA4",
		"\xE2\x93\x8B" => "\xE2\x93\xA5",
		"\xE2\x93\x8C" => "\xE2\x93\xA6",
		"\xE2\x93\x8D" => "\xE2\x93\xA7",
		"\xE2\x93\x8E" => "\xE2\x93\xA8",
		"\xE2\x93\x8F" => "\xE2\x93\xA9",
		"\xE2\xB0\x80" => "\xE2\xB0\xB0",
		"\xE2\xB0\x81" => "\xE2\xB0\xB1",
		"\xE2\xB0\x82" => "\xE2\xB0\xB2",
		"\xE2\xB0\x83" => "\xE2\xB0\xB3",
		"\xE2\xB0\x84" => "\xE2\xB0\xB4",
		"\xE2\xB0\x85" => "\xE2\xB0\xB5",
		"\xE2\xB0\x86" => "\xE2\xB0\xB6",
		"\xE2\xB0\x87" => "\xE2\xB0\xB7",
		"\xE2\xB0\x88" => "\xE2\xB0\xB8",
		"\xE2\xB0\x89" => "\xE2\xB0\xB9",
		"\xE2\xB0\x8A" => "\xE2\xB0\xBA",
		"\xE2\xB0\x8B" => "\xE2\xB0\xBB",
		"\xE2\xB0\x8C" => "\xE2\xB0\xBC",
		"\xE2\xB0\x8D" => "\xE2\xB0\xBD",
		"\xE2\xB0\x8E" => "\xE2\xB0\xBE",
		"\xE2\xB0\x8F" => "\xE2\xB0\xBF",
		"\xE2\xB0\x90" => "\xE2\xB1\x80",
		"\xE2\xB0\x91" => "\xE2\xB1\x81",
		"\xE2\xB0\x92" => "\xE2\xB1\x82",
		"\xE2\xB0\x93" => "\xE2\xB1\x83",
		"\xE2\xB0\x94" => "\xE2\xB1\x84",
		"\xE2\xB0\x95" => "\xE2\xB1\x85",
		"\xE2\xB0\x96" => "\xE2\xB1\x86",
		"\xE2\xB0\x97" => "\xE2\xB1\x87",
		"\xE2\xB0\x98" => "\xE2\xB1\x88",
		"\xE2\xB0\x99" => "\xE2\xB1\x89",
		"\xE2\xB0\x9A" => "\xE2\xB1\x8A",
		"\xE2\xB0\x9B" => "\xE2\xB1\x8B",
		"\xE2\xB0\x9C" => "\xE2\xB1\x8C",
		"\xE2\xB0\x9D" => "\xE2\xB1\x8D",
		"\xE2\xB0\x9E" => "\xE2\xB1\x8E",
		"\xE2\xB0\x9F" => "\xE2\xB1\x8F",
		"\xE2\xB0\xA0" => "\xE2\xB1\x90",
		"\xE2\xB0\xA1" => "\xE2\xB1\x91",
		"\xE2\xB0\xA2" => "\xE2\xB1\x92",
		"\xE2\xB0\xA3" => "\xE2\xB1\x93",
		"\xE2\xB0\xA4" => "\xE2\xB1\x94",
		"\xE2\xB0\xA5" => "\xE2\xB1\x95",
		"\xE2\xB0\xA6" => "\xE2\xB1\x96",
		"\xE2\xB0\xA7" => "\xE2\xB1\x97",
		"\xE2\xB0\xA8" => "\xE2\xB1\x98",
		"\xE2\xB0\xA9" => "\xE2\xB1\x99",
		"\xE2\xB0\xAA" => "\xE2\xB1\x9A",
		"\xE2\xB0\xAB" => "\xE2\xB1\x9B",
		"\xE2\xB0\xAC" => "\xE2\xB1\x9C",
		"\xE2\xB0\xAD" => "\xE2\xB1\x9D",
		"\xE2\xB0\xAE" => "\xE2\xB1\x9E",
		"\xE2\xB0\xAF" => "\xE2\xB1\x9F",
		"\xE2\xB1\xA0" => "\xE2\xB1\xA1",
		"\xE2\xB1\xA2" => "\xC9\xAB",
		"\xE2\xB1\xA3" => "\xE1\xB5\xBD",
		"\xE2\xB1\xA4" => "\xC9\xBD",
		"\xE2\xB1\xA7" => "\xE2\xB1\xA8",
		"\xE2\xB1\xA9" => "\xE2\xB1\xAA",
		"\xE2\xB1\xAB" => "\xE2\xB1\xAC",
		"\xE2\xB1\xAD" => "\xC9\x91",
		"\xE2\xB1\xAE" => "\xC9\xB1",
		"\xE2\xB1\xAF" => "\xC9\x90",
		"\xE2\xB1\xB0" => "\xC9\x92",
		"\xE2\xB1\xB2" => "\xE2\xB1\xB3",
		"\xE2\xB1\xB5" => "\xE2\xB1\xB6",
		"\xE2\xB1\xBE" => "\xC8\xBF",
		"\xE2\xB1\xBF" => "\xC9\x80",
		"\xE2\xB2\x80" => "\xE2\xB2\x81",
		"\xE2\xB2\x82" => "\xE2\xB2\x83",
		"\xE2\xB2\x84" => "\xE2\xB2\x85",
		"\xE2\xB2\x86" => "\xE2\xB2\x87",
		"\xE2\xB2\x88" => "\xE2\xB2\x89",
		"\xE2\xB2\x8A" => "\xE2\xB2\x8B",
		"\xE2\xB2\x8C" => "\xE2\xB2\x8D",
		"\xE2\xB2\x8E" => "\xE2\xB2\x8F",
		"\xE2\xB2\x90" => "\xE2\xB2\x91",
		"\xE2\xB2\x92" => "\xE2\xB2\x93",
		"\xE2\xB2\x94" => "\xE2\xB2\x95",
		"\xE2\xB2\x96" => "\xE2\xB2\x97",
		"\xE2\xB2\x98" => "\xE2\xB2\x99",
		"\xE2\xB2\x9A" => "\xE2\xB2\x9B",
		"\xE2\xB2\x9C" => "\xE2\xB2\x9D",
		"\xE2\xB2\x9E" => "\xE2\xB2\x9F",
		"\xE2\xB2\xA0" => "\xE2\xB2\xA1",
		"\xE2\xB2\xA2" => "\xE2\xB2\xA3",
		"\xE2\xB2\xA4" => "\xE2\xB2\xA5",
		"\xE2\xB2\xA6" => "\xE2\xB2\xA7",
		"\xE2\xB2\xA8" => "\xE2\xB2\xA9",
		"\xE2\xB2\xAA" => "\xE2\xB2\xAB",
		"\xE2\xB2\xAC" => "\xE2\xB2\xAD",
		"\xE2\xB2\xAE" => "\xE2\xB2\xAF",
		"\xE2\xB2\xB0" => "\xE2\xB2\xB1",
		"\xE2\xB2\xB2" => "\xE2\xB2\xB3",
		"\xE2\xB2\xB4" => "\xE2\xB2\xB5",
		"\xE2\xB2\xB6" => "\xE2\xB2\xB7",
		"\xE2\xB2\xB8" => "\xE2\xB2\xB9",
		"\xE2\xB2\xBA" => "\xE2\xB2\xBB",
		"\xE2\xB2\xBC" => "\xE2\xB2\xBD",
		"\xE2\xB2\xBE" => "\xE2\xB2\xBF",
		"\xE2\xB3\x80" => "\xE2\xB3\x81",
		"\xE2\xB3\x82" => "\xE2\xB3\x83",
		"\xE2\xB3\x84" => "\xE2\xB3\x85",
		"\xE2\xB3\x86" => "\xE2\xB3\x87",
		"\xE2\xB3\x88" => "\xE2\xB3\x89",
		"\xE2\xB3\x8A" => "\xE2\xB3\x8B",
		"\xE2\xB3\x8C" => "\xE2\xB3\x8D",
		"\xE2\xB3\x8E" => "\xE2\xB3\x8F",
		"\xE2\xB3\x90" => "\xE2\xB3\x91",
		"\xE2\xB3\x92" => "\xE2\xB3\x93",
		"\xE2\xB3\x94" => "\xE2\xB3\x95",
		"\xE2\xB3\x96" => "\xE2\xB3\x97",
		"\xE2\xB3\x98" => "\xE2\xB3\x99",
		"\xE2\xB3\x9A" => "\xE2\xB3\x9B",
		"\xE2\xB3\x9C" => "\xE2\xB3\x9D",
		"\xE2\xB3\x9E" => "\xE2\xB3\x9F",
		"\xE2\xB3\xA0" => "\xE2\xB3\xA1",
		"\xE2\xB3\xA2" => "\xE2\xB3\xA3",
		"\xE2\xB3\xAB" => "\xE2\xB3\xAC",
		"\xE2\xB3\xAD" => "\xE2\xB3\xAE",
		"\xE2\xB3\xB2" => "\xE2\xB3\xB3",
		"\xEA\x99\x80" => "\xEA\x99\x81",
		"\xEA\x99\x82" => "\xEA\x99\x83",
		"\xEA\x99\x84" => "\xEA\x99\x85",
		"\xEA\x99\x86" => "\xEA\x99\x87",
		"\xEA\x99\x88" => "\xEA\x99\x89",
		"\xEA\x99\x8A" => "\xEA\x99\x8B",
		"\xEA\x99\x8C" => "\xEA\x99\x8D",
		"\xEA\x99\x8E" => "\xEA\x99\x8F",
		"\xEA\x99\x90" => "\xEA\x99\x91",
		"\xEA\x99\x92" => "\xEA\x99\x93",
		"\xEA\x99\x94" => "\xEA\x99\x95",
		"\xEA\x99\x96" => "\xEA\x99\x97",
		"\xEA\x99\x98" => "\xEA\x99\x99",
		"\xEA\x99\x9A" => "\xEA\x99\x9B",
		"\xEA\x99\x9C" => "\xEA\x99\x9D",
		"\xEA\x99\x9E" => "\xEA\x99\x9F",
		"\xEA\x99\xA0" => "\xEA\x99\xA1",
		"\xEA\x99\xA2" => "\xEA\x99\xA3",
		"\xEA\x99\xA4" => "\xEA\x99\xA5",
		"\xEA\x99\xA6" => "\xEA\x99\xA7",
		"\xEA\x99\xA8" => "\xEA\x99\xA9",
		"\xEA\x99\xAA" => "\xEA\x99\xAB",
		"\xEA\x99\xAC" => "\xEA\x99\xAD",
		"\xEA\x9A\x80" => "\xEA\x9A\x81",
		"\xEA\x9A\x82" => "\xEA\x9A\x83",
		"\xEA\x9A\x84" => "\xEA\x9A\x85",
		"\xEA\x9A\x86" => "\xEA\x9A\x87",
		"\xEA\x9A\x88" => "\xEA\x9A\x89",
		"\xEA\x9A\x8A" => "\xEA\x9A\x8B",
		"\xEA\x9A\x8C" => "\xEA\x9A\x8D",
		"\xEA\x9A\x8E" => "\xEA\x9A\x8F",
		"\xEA\x9A\x90" => "\xEA\x9A\x91",
		"\xEA\x9A\x92" => "\xEA\x9A\x93",
		"\xEA\x9A\x94" => "\xEA\x9A\x95",
		"\xEA\x9A\x96" => "\xEA\x9A\x97",
		"\xEA\x9A\x98" => "\xEA\x9A\x99",
		"\xEA\x9A\x9A" => "\xEA\x9A\x9B",
		"\xEA\x9C\xA2" => "\xEA\x9C\xA3",
		"\xEA\x9C\xA4" => "\xEA\x9C\xA5",
		"\xEA\x9C\xA6" => "\xEA\x9C\xA7",
		"\xEA\x9C\xA8" => "\xEA\x9C\xA9",
		"\xEA\x9C\xAA" => "\xEA\x9C\xAB",
		"\xEA\x9C\xAC" => "\xEA\x9C\xAD",
		"\xEA\x9C\xAE" => "\xEA\x9C\xAF",
		"\xEA\x9C\xB2" => "\xEA\x9C\xB3",
		"\xEA\x9C\xB4" => "\xEA\x9C\xB5",
		"\xEA\x9C\xB6" => "\xEA\x9C\xB7",
		"\xEA\x9C\xB8" => "\xEA\x9C\xB9",
		"\xEA\x9C\xBA" => "\xEA\x9C\xBB",
		"\xEA\x9C\xBC" => "\xEA\x9C\xBD",
		"\xEA\x9C\xBE" => "\xEA\x9C\xBF",
		"\xEA\x9D\x80" => "\xEA\x9D\x81",
		"\xEA\x9D\x82" => "\xEA\x9D\x83",
		"\xEA\x9D\x84" => "\xEA\x9D\x85",
		"\xEA\x9D\x86" => "\xEA\x9D\x87",
		"\xEA\x9D\x88" => "\xEA\x9D\x89",
		"\xEA\x9D\x8A" => "\xEA\x9D\x8B",
		"\xEA\x9D\x8C" => "\xEA\x9D\x8D",
		"\xEA\x9D\x8E" => "\xEA\x9D\x8F",
		"\xEA\x9D\x90" => "\xEA\x9D\x91",
		"\xEA\x9D\x92" => "\xEA\x9D\x93",
		"\xEA\x9D\x94" => "\xEA\x9D\x95",
		"\xEA\x9D\x96" => "\xEA\x9D\x97",
		"\xEA\x9D\x98" => "\xEA\x9D\x99",
		"\xEA\x9D\x9A" => "\xEA\x9D\x9B",
		"\xEA\x9D\x9C" => "\xEA\x9D\x9D",
		"\xEA\x9D\x9E" => "\xEA\x9D\x9F",
		"\xEA\x9D\xA0" => "\xEA\x9D\xA1",
		"\xEA\x9D\xA2" => "\xEA\x9D\xA3",
		"\xEA\x9D\xA4" => "\xEA\x9D\xA5",
		"\xEA\x9D\xA6" => "\xEA\x9D\xA7",
		"\xEA\x9D\xA8" => "\xEA\x9D\xA9",
		"\xEA\x9D\xAA" => "\xEA\x9D\xAB",
		"\xEA\x9D\xAC" => "\xEA\x9D\xAD",
		"\xEA\x9D\xAE" => "\xEA\x9D\xAF",
		"\xEA\x9D\xB9" => "\xEA\x9D\xBA",
		"\xEA\x9D\xBB" => "\xEA\x9D\xBC",
		"\xEA\x9D\xBD" => "\xE1\xB5\xB9",
		"\xEA\x9D\xBE" => "\xEA\x9D\xBF",
		"\xEA\x9E\x80" => "\xEA\x9E\x81",
		"\xEA\x9E\x82" => "\xEA\x9E\x83",
		"\xEA\x9E\x84" => "\xEA\x9E\x85",
		"\xEA\x9E\x86" => "\xEA\x9E\x87",
		"\xEA\x9E\x8B" => "\xEA\x9E\x8C",
		"\xEA\x9E\x8D" => "\xC9\xA5",
		"\xEA\x9E\x90" => "\xEA\x9E\x91",
		"\xEA\x9E\x92" => "\xEA\x9E\x93",
		"\xEA\x9E\x96" => "\xEA\x9E\x97",
		"\xEA\x9E\x98" => "\xEA\x9E\x99",
		"\xEA\x9E\x9A" => "\xEA\x9E\x9B",
		"\xEA\x9E\x9C" => "\xEA\x9E\x9D",
		"\xEA\x9E\x9E" => "\xEA\x9E\x9F",
		"\xEA\x9E\xA0" => "\xEA\x9E\xA1",
		"\xEA\x9E\xA2" => "\xEA\x9E\xA3",
		"\xEA\x9E\xA4" => "\xEA\x9E\xA5",
		"\xEA\x9E\xA6" => "\xEA\x9E\xA7",
		"\xEA\x9E\xA8" => "\xEA\x9E\xA9",
		"\xEA\x9E\xAA" => "\xC9\xA6",
		"\xEA\x9E\xAB" => "\xC9\x9C",
		"\xEA\x9E\xAC" => "\xC9\xA1",
		"\xEA\x9E\xAD" => "\xC9\xAC",
		"\xEA\x9E\xAE" => "\xC9\xAA",
		"\xEA\x9E\xB0" => "\xCA\x9E",
		"\xEA\x9E\xB1" => "\xCA\x87",
		"\xEA\x9E\xB2" => "\xCA\x9D",
		"\xEA\x9E\xB3" => "\xEA\xAD\x93",
		"\xEA\x9E\xB4" => "\xEA\x9E\xB5",
		"\xEA\x9E\xB6" => "\xEA\x9E\xB7",
		"\xEA\x9E\xB8" => "\xEA\x9E\xB9",
		"\xEA\x9E\xBA" => "\xEA\x9E\xBB",
		"\xEA\x9E\xBC" => "\xEA\x9E\xBD",
		"\xEA\x9E\xBE" => "\xEA\x9E\xBF",
		"\xEA\x9F\x80" => "\xEA\x9F\x81",
		"\xEA\x9F\x82" => "\xEA\x9F\x83",
		"\xEA\x9F\x84" => "\xEA\x9E\x94",
		"\xEA\x9F\x85" => "\xCA\x82",
		"\xEA\x9F\x86" => "\xE1\xB6\x8E",
		"\xEA\x9F\x87" => "\xEA\x9F\x88",
		"\xEA\x9F\x89" => "\xEA\x9F\x8A",
		"\xEA\x9F\x8B" => "\xC9\xA4",
		"\xEA\x9F\x8C" => "\xEA\x9F\x8D",
		"\xEA\x9F\x8E" => "\xEA\x9F\x8F",
		"\xEA\x9F\x90" => "\xEA\x9F\x91",
		"\xEA\x9F\x92" => "\xEA\x9F\x93",
		"\xEA\x9F\x94" => "\xEA\x9F\x95",
		"\xEA\x9F\x96" => "\xEA\x9F\x97",
		"\xEA\x9F\x98" => "\xEA\x9F\x99",
		"\xEA\x9F\x9A" => "\xEA\x9F\x9B",
		"\xEA\x9F\x9C" => "\xC6\x9B",
		"\xEA\x9F\xB5" => "\xEA\x9F\xB6",
		"\xEF\xAC\x80" => "\xEF\xAC\x80",
		"\xEF\xAC\x81" => "\xEF\xAC\x81",
		"\xEF\xAC\x82" => "\xEF\xAC\x82",
		"\xEF\xAC\x83" => "\xEF\xAC\x83",
		"\xEF\xAC\x84" => "\xEF\xAC\x84",
		"\xEF\xAC\x85" => "\xEF\xAC\x85",
		"\xEF\xAC\x86" => "\xEF\xAC\x86",
		"\xEF\xAC\x93" => "\xEF\xAC\x93",
		"\xEF\xAC\x94" => "\xEF\xAC\x94",
		"\xEF\xAC\x95" => "\xEF\xAC\x95",
		"\xEF\xAC\x96" => "\xEF\xAC\x96",
		"\xEF\xAC\x97" => "\xEF\xAC\x97",
		"\xEF\xBC\xA1" => "\xEF\xBD\x81",
		"\xEF\xBC\xA2" => "\xEF\xBD\x82",
		"\xEF\xBC\xA3" => "\xEF\xBD\x83",
		"\xEF\xBC\xA4" => "\xEF\xBD\x84",
		"\xEF\xBC\xA5" => "\xEF\xBD\x85",
		"\xEF\xBC\xA6" => "\xEF\xBD\x86",
		"\xEF\xBC\xA7" => "\xEF\xBD\x87",
		"\xEF\xBC\xA8" => "\xEF\xBD\x88",
		"\xEF\xBC\xA9" => "\xEF\xBD\x89",
		"\xEF\xBC\xAA" => "\xEF\xBD\x8A",
		"\xEF\xBC\xAB" => "\xEF\xBD\x8B",
		"\xEF\xBC\xAC" => "\xEF\xBD\x8C",
		"\xEF\xBC\xAD" => "\xEF\xBD\x8D",
		"\xEF\xBC\xAE" => "\xEF\xBD\x8E",
		"\xEF\xBC\xAF" => "\xEF\xBD\x8F",
		"\xEF\xBC\xB0" => "\xEF\xBD\x90",
		"\xEF\xBC\xB1" => "\xEF\xBD\x91",
		"\xEF\xBC\xB2" => "\xEF\xBD\x92",
		"\xEF\xBC\xB3" => "\xEF\xBD\x93",
		"\xEF\xBC\xB4" => "\xEF\xBD\x94",
		"\xEF\xBC\xB5" => "\xEF\xBD\x95",
		"\xEF\xBC\xB6" => "\xEF\xBD\x96",
		"\xEF\xBC\xB7" => "\xEF\xBD\x97",
		"\xEF\xBC\xB8" => "\xEF\xBD\x98",
		"\xEF\xBC\xB9" => "\xEF\xBD\x99",
		"\xEF\xBC\xBA" => "\xEF\xBD\x9A",
	);
}

?>