<div class="container mx-auto px-4 py-8">
    <h1 class="text-3xl font-bold mb-6 text-gray-800">Crypto Directory</h1>
    
    <div class="bg-white p-4 rounded-lg shadow-sm mb-8 border border-gray-200">
        <div class="flex flex-col md:flex-row gap-4">
            <div class="flex-1">
                <input wire:model.live.debounce.300ms="search" type="text" placeholder="Search projects..." class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:outline-none">
            </div>
            <div class="w-full md:w-48">
                <select wire:model.live="category" class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:outline-none">
                    <option value="">All Categories</option>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($cat->slug); ?>"><?php echo e($cat->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </select>
            </div>
             <div class="w-full md:w-48">
                <select wire:model.live="filterType" class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:outline-none">
                    <option value="">All Types</option>
                    <option value="verified">Verified Only</option>
                    <option value="no_kyc">No KYC</option>
                    <option value="onion">Tor/Onion</option>
                </select>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition-shadow duration-300 border border-gray-100">
                <div class="p-6">
                    <div class="flex justify-between items-start mb-2">
                        <span class="inline-block px-2 py-1 text-xs font-semibold tracking-wide text-blue-800 uppercase bg-blue-100 rounded-full">
                            <?php echo e($project->category->name); ?>

                        </span>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($project->online_status === 'online'): ?>
                            <span class="flex items-center text-green-600 text-xs font-bold">
                                <span class="w-2 h-2 bg-green-500 rounded-full mr-1"></span> Online
                            </span>
                        <?php else: ?>
                            <span class="flex items-center text-red-500 text-xs font-bold">
                                <span class="w-2 h-2 bg-red-500 rounded-full mr-1"></span> Offline
                            </span>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>

                    <h2 class="text-xl font-bold text-gray-900 mb-2">
                        <a href="<?php echo e(route('projects.show', $project)); ?>" class="hover:text-blue-600 transition-colors">
                            <?php echo e($project->name); ?>

                        </a>
                    </h2>
                    
                    <p class="text-gray-600 text-sm line-clamp-3 mb-4 h-15">
                        <?php echo e($project->description); ?>

                    </p>
                    
                    <div class="flex items-center justify-between pt-4 border-t border-gray-100">
                        <div class="flex items-center">
                            <svg class="w-4 h-4 text-yellow-400 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" />
                            </svg>
                            <span class="font-bold text-gray-700"><?php echo e($project->star_rating); ?></span>
                            <span class="text-gray-400 text-xs ml-1">(<?php echo e($project->review_count); ?>)</span>
                        </div>
                        
                        <a href="<?php echo e(route('projects.show', $project)); ?>" class="text-blue-600 hover:text-blue-800 text-sm font-semibold">
                            Details &rarr;
                        </a>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
    
    <div class="mt-8">
        <?php echo e($projects->links()); ?>

    </div>
</div>
<?php /**PATH C:\Users\Hp\Desktop\MY Work\WeLiveCrypto\directory-app\resources\views/livewire/project-list.blade.php ENDPATH**/ ?>