<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Project;
use App\Models\Category;

class ProjectSeeder extends Seeder
{
    public function run(): void
    {
        // Ensure categories exist
        $exchangeCat = Category::where('slug', 'exchanges')->first();
        $mixerCat = Category::where('slug', 'mixers')->first();
        $walletCat = Category::where('slug', 'wallets')->first();
        $casinoCat = Category::where('slug', 'casinos-sportsbooks')->first();
        
        // 1. Exchange Example (CEX)
        if ($exchangeCat) {
            Project::create([
                'name' => 'SafeTrade CEX',
                'slug' => 'safetrade-cex',
                'description' => 'A leading centralized exchange focused on security and low fees. Supports over 200 cryptocurrencies and offers advanced trading tools.',
                'website_url' => 'https://example-safetrade.com',
                'category_id' => $exchangeCat->id,
                'industry' => 'Exchange',
                'online_status' => 'online',
                'list_status' => 'verified',
                'star_rating' => 4.5,
                'review_count' => 128,
                'trust_score' => 95,
                'privacy_level' => 'KYC Required',
                'supported_cryptos' => ['BTC', 'ETH', 'LTC', 'XMR', 'USDT'],
                'supported_networks' => ['Clear Net'],
                'features' => ['Spot Trading', 'Margin Trading', 'Mobile App'],
                'scam_reason' => null,
                // Specifics
                'withdrawal_fees' => '0.0005 BTC',
                'liquidity_indicator' => 'High',
            ]);
        }

        // 2. Exchange Example (DEX)
        if ($exchangeCat) {
            Project::create([
                'name' => 'UniSwap Clone',
                'slug' => 'uniswap-clone',
                'description' => 'Decentralized exchange protocol for automated liquidity provision on Ethereum.',
                'website_url' => 'https://example-dex.org',
                'category_id' => $exchangeCat->id,
                'industry' => 'DeFi',
                'online_status' => 'online',
                'list_status' => 'approved',
                'star_rating' => 4.8,
                'review_count' => 340,
                'trust_score' => 90,
                'privacy_level' => 'No KYC',
                'supported_cryptos' => ['ETH', 'ERC-20 Tokens'],
                'supported_networks' => ['Clear Net', 'IPFS'],
                'features' => ['Swapping', 'Liquidity Pools'],
                'own_liquidity' => true,
            ]);
        }

        // 3. Mixer Example
        if ($mixerCat) {
            Project::create([
                'name' => 'AnonMixer Pro',
                'slug' => 'anonmixer-pro',
                'description' => 'High volume Bitcoin mixer with low fees and no logs policy. Essential for privacy.',
                'website_url' => 'http://exampleonionaddress.onion',
                'category_id' => $mixerCat->id,
                'industry' => 'Privacy',
                'online_status' => 'online',
                'list_status' => 'verified',
                'star_rating' => 4.9,
                'review_count' => 56,
                'trust_score' => 98,
                'privacy_level' => 'No KYC',
                'supported_cryptos' => ['BTC'],
                'supported_networks' => ['TOR'],
                'features' => ['Letter of Guarantee', 'No Logs'],
                'no_log_policy' => true,
                // Specifics
                'min_service_fee' => 0.5, // %
                'min_time_delay' => 1, // Hours
                'letter_of_guarantee' => true,
            ]);
        }

        // 4. Wallet Example
        if ($walletCat) {
            Project::create([
                'name' => 'SecureVault Wallet',
                'slug' => 'securevault-wallet',
                'description' => 'Non-custodial multi-chain wallet with hardware support.',
                'website_url' => 'https://example-wallet.io',
                'category_id' => $walletCat->id,
                'industry' => 'Wallet',
                'online_status' => 'online',
                'list_status' => 'verified',
                'star_rating' => 4.2,
                'review_count' => 89,
                'trust_score' => 85,
                'privacy_level' => 'No KYC',
                'supported_cryptos' => ['BTC', 'ETH', 'SOL', 'DOT'],
                'supported_networks' => ['Clear Net', 'Mobile', 'Desktop'],
                'features' => ['Staking', 'Swap', 'NFT Support'],
                'source_code_url' => 'https://github.com/example/wallet',
                // Specifics
                'custodial_type' => 'Non-Custodial',
            ]);
        }

        // 5. Casino Example (Scam)
        if ($casinoCat) {
            Project::create([
                'name' => 'RiggedSlots',
                'slug' => 'riggedslots',
                'description' => 'Crypto casino offering 200% deposit bonus. Reports of blocked withdrawals.',
                'website_url' => 'https://example-scam-casino.com',
                'category_id' => $casinoCat->id,
                'industry' => 'Gambling',
                'online_status' => 'offline',
                'list_status' => 'scam',
                'star_rating' => 1.1,
                'review_count' => 45,
                'trust_score' => 0,
                'privacy_level' => 'Optional KYC',
                'supported_cryptos' => ['BTC', 'LTC'],
                'supported_networks' => ['Clear Net'],
                'features' => ['Slots', 'Live Dealer'],
                'scam_reason' => 'Multiple user reports of non-payment and rigged games.',
            ]);
        }
        
        // 6. Proposed Project (Pending Approval)
        if ($exchangeCat) {
            Project::create([
                'name' => 'New DeFi Protocol',
                'slug' => 'new-defi-protocol',
                'description' => 'A new revolutionary protocol awaiting audit.',
                'website_url' => 'https://example-new-defi.io',
                'category_id' => $exchangeCat->id,
                'industry' => 'DeFi',
                'online_status' => 'online',
                'list_status' => 'proposed',
                'star_rating' => 0,
                'review_count' => 0,
                'trust_score' => 50,
                'privacy_level' => 'No KYC',
                'supported_cryptos' => ['ETH'],
                'supported_networks' => ['Clear Net'],
            ]);
        }
    }
}
