<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    protected $guarded = ['id'];

    protected $casts = [
        'supported_cryptos' => 'array',
        'supported_networks' => 'array',
        'features' => 'array',
        'discussion_channels' => 'array',
        'security_features' => 'array',
        'letter_of_guarantee' => 'boolean',
        'ownership_verified' => 'boolean',
        'registration_required' => 'boolean',
        'no_log_policy' => 'boolean',
        'source_code_availability' => 'boolean',
        'own_liquidity' => 'boolean',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function reviews()
    {
        return $this->hasMany(Review::class);
    }
}
