<?php

namespace App\Livewire;

use Livewire\Component;

use App\Models\Project;
use App\Models\Category;
use Livewire\WithPagination;

class ProjectList extends Component
{
    use WithPagination;

    public $search = '';
    public $category = '';
    public $filterType = '';

    protected $queryString = ['search', 'category', 'filterType'];

    public function updatedSearch()
    {
        $this->resetPage();
    }

    public function updatedCategory()
    {
        $this->resetPage();
    }

    public function render()
    {
        $query = Project::with('category')->where('list_status', '!=', 'proposed');

        if ($this->search) {
            $query->where(function($q) {
                $q->where('name', 'like', '%' . $this->search . '%')
                  ->orWhere('description', 'like', '%' . $this->search . '%');
            });
        }

        if ($this->category) {
            $query->whereHas('category', function($q) {
                $q->where('slug', $this->category);
            });
        }
        
        if ($this->filterType === 'no_kyc') {
            $query->where('privacy_level', 'No KYC');
        } elseif ($this->filterType === 'verified') {
            $query->where('list_status', 'verified');
        } elseif ($this->filterType === 'onion') {
             $query->whereJsonContains('supported_networks', 'TOR');
        }

        return view('livewire.project-list', [
            'projects' => $query->latest()->paginate(12),
            'categories' => Category::orderBy('name')->get(),
        ]);
    }
}
